// admin-giros-proveedor.js

PROVEEDORES_PREFIX = `${BASE_URL}proveedores`

// Funcion que exportara el listado a excel
async function exportarExcel() {
    showLoadingAlert("Exportando a Excel...")

    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    let url = `${PROVEEDORES_PREFIX}/admin-giros-proveedor`
    let headers = new Headers()
    headers.append("X-CSRFToken", csrftoken)
    headers.append("x-requested-with", "XMLHttpRequest")
    //headers.append("Content-Type", "application/json")

    /*
    let body = {
        exportar_excel: true
    }
    */
    let body = new URLSearchParams()
    body.append("exportar_excel", true)

    const result = await fetch(url, {
        method: "POST",
        headers: headers,
        //body: JSON.stringify(body)
        body: body
    })

    if (!result.ok) {
        let error = await result.json()
        console.log(error)
    }


    let fileName = getFileNameFromResponse(result)

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = fileName;
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf() {
    showLoadingAlert("Exportando a PDF...")
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    let url = `${PROVEEDORES_PREFIX}/admin-giros-proveedor`
    let headers = new Headers()
    headers.append("X-CSRFToken", csrftoken)
    headers.append("x-requested-with", "XMLHttpRequest")
    //headers.append("Content-Type", "application/json")

    /*
    let body = {
        exportar_excel: true
    }
    */
    let body = new URLSearchParams()
    body.append("exportar_pdf", true)

    const result = await fetch(url, {
        method: "POST",
        headers: headers,
        //body: JSON.stringify(body)
        body: body
    })

    if (!result.ok) {
        let error = await result.json()
        console.log(error)
    }


    let fileName = getFileNameFromResponse(result)

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = fileName;
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que mostrara una alerta para que el usuario modifique el nombre de un giro
async function cambiarNombreGiroProveedor(giroId, nombreActualGiro) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();
    const inputValue = nombreActualGiro

    const { value: nuevoNombre } = await Swal.fire({
        title: "Ingrese un nuevo nombre",
        input: "text",
        inputLabel: "",
        inputValue,
        showCancelButton: true,
        cancelButtonText: "Cancelar",
        inputValidator: (value) => {
            if (!value) {
                return "¡Necesitas escribir algo!";
            }
        }
    });

    if (nuevoNombre) {
        showLoadingAlert("Modificando nombre...")
        $.ajax({
            type: "POST",
            url: `${PROVEEDORES_PREFIX}/admin-giros-proveedor`,
            data: {
                giroId: giroId,
                nuevoNombre: nuevoNombre,
                editar: true
            },
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                showSuccessConfirmAlert("Se modifico el nombre del giro correctamente.", location.href)
            },
            error: function (a, b, c) {
                console.log(a + b + c)
            }
        })
    }
}