// subir-documentos-prov.js

// Variable en donde se guardara el clon de archivo de algun input file para posteriormente
// recuperar este valor y guardarlo nuevamente
var clone = {};

PROVEEDORES_PREFIX = `${BASE_URL}proveedores`

$(document).ready(function () {
    // Evento de carga/remplazo de documentos
    $("#subir-doc-prov-form").submit(function () {
        showLoadingAlert('Subiendo/Remplazando documentos...')
    })
})


// Funcion que eliminara un archivo de un tipo de documento de un cliente en especifico
function eliminarDocProveedor(
    proveedorId,
    codigoTipoDocumento,
    nombreCarpetaDoc
) {
    // Mostrara una alerta de confirmacion al usuario
    Swal.fire({
        title: "Eliminar archivo",
        text: "¿Estas seguro de eliminar el archivo? Esta acción es definitiva y no se puede deshacer.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        cancelButtonText: "Cancelar",
        confirmButtonText: "Si, eliminar!"
    }).then((result) => {
        if (result.isConfirmed) {
            // Muestra alerta de carga
            showLoadingAlert("Eliminando archivo...")

            // Comienza proceso de eliminacion
            var csrftoken = $("[name=csrfmiddlewaretoken]").val();

            $.ajax(
                {
                    method: "POST",
                    url: `${PROVEEDORES_PREFIX}/subir-documentos-proveedor/${proveedorId}`,
                    headers: { 'X-CSRFToken': csrftoken },
                    data: {
                        proveedorId: proveedorId,
                        codigoTipoDocumento: codigoTipoDocumento,
                        eliminarArchivo: true
                    },
                    success: function (data) {
                        // Cierra las alertas actuales
                        Swal.close()

                        // Muestra alerta de exito
                        Swal.fire(
                            {
                                title: "¡Exito!",
                                text: "Se elimino el archivo exitosamente",
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }
                        )
                        // Oculta el check de estatus
                        $(`#${nombreCarpetaDoc}-check`).css('display', 'none')
                        // Elimina el valor del <input> de tipo 'file'
                        $(`#${nombreCarpetaDoc}-input`).val(null)
                        // Desactiva el boton de eliminar
                        //$(`#${nombreCarpetaDoc}-del-btn`).removeClass("table-icon")
                        //$(`#${nombreCarpetaDoc}-del-btn`).addClass("disabled-table-icon")
                        //$(`#${nombreCarpetaDoc}-del-btn`).on('click', function () { })
                        $(`#${nombreCarpetaDoc}-del-btn`).off('click')
                        $(`#${nombreCarpetaDoc}-del-btn`).removeAttr('onclick')
                        $(`#${nombreCarpetaDoc}-del-btn`).attr('disabled', 'disabled')

                        // Indica que el archivo de este tipo de documento se elimino recientemente
                        $(`#file-del-${nombreCarpetaDoc}`).val("T")

                        // Reinicia el input date(Vigencia)
                        $(`#vigencia-${nombreCarpetaDoc}`).val(null)
                        // Reinicia el input text(Observaciones)
                        $(`#observaciones-${nombreCarpetaDoc}`).val("")
                    },
                    error: function (a, b, c) {
                        alert(a + b + c)
                    }
                }
            )
        }
    })
}

// Funcion que se invocara cuando el input de tipo 'file' de cada tipo de documento
// cambie
function onDocInputFileChange(
    event,
    nombreCarpetaDoc
) {
    $(document).ready(function () {
        //alert(nombreTipoDocumento)
        // Muestra el check de estatus de el tipo de documento
        $(`#${nombreCarpetaDoc}-check`).css('display', 'block')

        // Muestra disponible el boton de 'Eliminar seleccion'
        $(`#${nombreCarpetaDoc}-del-select-btn`).removeClass('disabled-table-icon')
        $(`#${nombreCarpetaDoc}-del-select-btn`).addClass("table-icon")

        // Muestra desactivado el boton de 'eliminar archivo'
        $(`#${nombreCarpetaDoc}-del-btn`).removeClass("table-icon")
        $(`#${nombreCarpetaDoc}-del-btn`).addClass("disabled-table-icon")
        $(`#${nombreCarpetaDoc}-del-btn`).off('click')
        $(`#${nombreCarpetaDoc}-del-btn`).removeAttr('onclick')

        // Hace que el input de tipo date 'Vigencia' sea obligatorio
        $(`#vigencia-${nombreCarpetaDoc}`).prop('required', true)

        // Evento de click al boton de 'Eliminar seleccion'
        $(`#${nombreCarpetaDoc}-del-select-btn`).on('click', function () {
            // Oculta el check de estatus
            $(`#${nombreCarpetaDoc}-check`).css('display', 'none')
            // Elimina el valor del <input> de tipo 'file'
            $(`#${nombreCarpetaDoc}-input`).val(null)
            // Boton de eliminar seleccion
            $(`#${nombreCarpetaDoc}-del-select-btn`).addClass('disabled-table-icon')
            $(`#${nombreCarpetaDoc}-del-select-btn`).removeClass("table-icon")

            $(`#${nombreCarpetaDoc}-del-select-btn`).off('click')

            // Hace que el input de tipo date 'Vigencia' NO sea obligatorio 
            $(`#vigencia-${nombreCarpetaDoc}`).prop('required', false)
            // Reinicia el input date(Vigencia)
            $(`#vigencia-${nombreCarpetaDoc}`).val(null)
            // Reinicia el input text(Observaciones)
            $(`#observaciones-${nombreCarpetaDoc}`).val("")

        })

        //$(`#${nombreCarpetaDoc}-del-btn`).toggleClass("disabled-table-icon table-icon")
        /*
        $(`#${nombreCarpetaDoc}-del-btn`).on('click', function () {
            eliminarDocCliente(clienteId, codigoDocumento, nombreCarpetaDoc, archivoSubido)
        })
        */
    })

    // -- Solucion bug al dar click en el boton de 'Cancelar' --
    var fileElement = event.target,
        files = fileElement.files
    if (fileElement.value == "") { // solamente si el valor estuviera vacio(dio click en cancelar) restaura el valor
        clone[fileElement.id].insertBefore(fileElement);
        $(fileElement).remove()
    }

}


// Metodo que clonara el archivo de algun input file para recuperarlo en caso de que el usuario
// de click en el boton 'Cancelar' al abrir el dialogo de seleccion de archivo
//inputClicked()
function inputClicked(event) {
    var fileElement = event.target
    if (fileElement.value != "") {
        console.log("Clone( #" + fileElement.id + " ) : " + fileElement.value.split("\\").pop())
        clone[fileElement.id] = $(fileElement).clone() // Clona el valor del input
    }
}

// Funcion que se invocara cuando cambie el checkbox de 'No aplica'
function onNoAplicaChange(
    event,
    proveedorId,
    codigoTipoDocumento,
    nombreCarpetaDoc,
    cargado,
    noAplica
) {
    // Desactiva el tipo de documento
    if (event.target.checked == true) {
        $("#vigencia-" + nombreCarpetaDoc).prop('disabled', true)
        $("#observaciones-" + nombreCarpetaDoc).prop('disabled', true)
        $(`#${nombreCarpetaDoc}-input`).attr('disabled', "disabled")
        //$(`#${nombreCarpetaDoc}-check`).css('display', 'none')
        //alert(`#${nombreCarpetaDoc}-del-btn`)
        $(`#${nombreCarpetaDoc}-del-btn`).attr('disabled', "disabled")
        $(`#${nombreCarpetaDoc}-del-btn`).removeAttr("onclick")
        $(`#${nombreCarpetaDoc}-del-btn`).off('click')
    } else {
        // Activa el tipo de documento
        $("#vigencia-" + nombreCarpetaDoc).prop('disabled', false)
        $("#observaciones-" + nombreCarpetaDoc).prop('disabled', false)
        $(`#${nombreCarpetaDoc}-input`).prop('disabled', false)
        // Si en el registro de documento hay un archivo cargado actualmente
        // el documento originalmente no tenia activada la opcion de 'No aplica'
        // no elimino el archivo recientemente
        let deletedRecent = $(`#file-del-${nombreCarpetaDoc}`).val() // 'T' o 'F'
        if (cargado == "True" && noAplica == "False" && deletedRecent == "F") {
            $(`#${nombreCarpetaDoc}-del-btn`).removeAttr("disabled")
            $(`#${nombreCarpetaDoc}-del-btn`).on('click', () => {
                eliminarDocProveedor(proveedorId, codigoTipoDocumento, nombreCarpetaDoc)
            })
        }
    }
}