// agregar-proveedor.js

PROVEEDORES = `${BASE_URL}proveedores`
API = `${BASE_URL}api`

// Indice de contactos
let indiceContacto = 0;
// Lista de id de los contactos guardados actualmente
let contactosGuardadosId = [];

// Indice del contacto que se esta modificando
let indiceContactoModificacion = undefined;

$(document).ready(function () {
    // Contenedor del listado de contactos
    let contactosContainer = document.getElementById("contactos-container")

    // Formulario
    let agregarProveedorForm = document.getElementById("agregar-proveedor-form")

    // --------- Subida de formulario principal -----------
    $("#agregar-proveedor-form").submit(function (evt) {
        // Muestra alerta de carga
        showLoadingAlert("Agregando proveedor...")

        // --- Verifica que haya validado un código postal personal ---
        let municipio = $("#municipio-ciudad").val() || ""

        if (municipio == "") {
            evt.preventDefault()
            Swal.close()
            // Si no valido el codigo postal, mostrara una alerta de error
            showFailAlert("¡Atención!", "Debe validar el código postal actual y seleccionar una colonia.")
        }

        // --- Verifica que haya validado un código postal fiscal ----
        let municipioFiscal = $("#municipio-ciudad-fiscal").val() || ""

        if (municipioFiscal == "") {
            evt.preventDefault()
            Swal.close()
            // Si no valido el codigo postal fiscal, mostrara una alerta de error
            showFailAlert("¡Atención!", "Debe validar el código postal fiscal y seleccionar una colonia.")
        }

        // Aqui obtiene las opciones seleccionadas del select de oficinas
        let oficinaListItems = document.getElementById("oficina-select-list-items")
        oficinaListItems = oficinaListItems.querySelectorAll("li")

        // Obtiene el número de oficinas seleccionadas actualmente
        let checkedItems = document.querySelectorAll(".checked.oficina-item")


        if (checkedItems.length == 0) {
            evt.preventDefault()
            showFailAlert('¡Atención!', "Debe seleccionar por lo menos una oficina")
            return;
        }

        oficinaListItems.forEach(item => {
            // Si el item esta seleccionado
            if (item.classList.contains("checked")) {
                // Obtiene el texto de el item
                let textContent = item.getElementsByClassName("item-text")[0].textContent
                // Crea un input hidden para enviarlo para la busqueda
                let inputHidden = document.createElement("input")
                inputHidden.type = "hidden"
                inputHidden.value = textContent
                inputHidden.name = "oficinas-items[]"
                // Agrega el input al formulario
                agregarProveedorForm.appendChild(inputHidden)

            }
        })


    })


    // ---------------- Validacion código postal personal --------------

    // Evento de boton para validacion
    $("#validar-codigo-postal").on('click', function () {
        //alert("click")
        // Verifica si el codigo postal es valido
        let value = String($("#codigo-postal").val())
        //alert(value.length)
        if (value.length == 5) {
            // Desactiva el boton temporalmente
            $("#validar-codigo-postal").attr('disabled', true)

            // Muestra datos
            fetch(`${API}/obtener-info-cp?` + new URLSearchParams({
                cp: value
            })).then((response) => {
                return response.json()
                /*
                if (response.ok) {

                }
                return Promise.reject(response);
                */
            }).then((responseJson) => {
                //let jsonResult = JSON.parse(responseJson)
                let jsonResult = responseJson
                // Verificara si hubo error de parte de la API
                if (jsonResult["error"]) {
                    showFailAlert("Ocurrio un error con la API (Codigo " + jsonResult["code_error"] + ")", jsonResult["error_message"])
                }
                // Aqui obtendra los valores de la respuesta de el CP
                let response = jsonResult["response"]

                // Entidad federativa
                $("#entidad-federativa").val(response["estado"])
                // Municipio
                $("#municipio-ciudad").val(response["municipio"])

                // Colonias
                $("#colonia-select").append($('<option>', { // Agrega elemento placeholder
                    value: "",
                    text: "Seleccione una colonia",
                    selected: true
                }))
                // Agrega colonias
                $.each(response["asentamiento"], function (i, asentamiento) {
                    $("#colonia-select").append($('<option>', {
                        value: asentamiento,
                        text: asentamiento
                    }))
                })

                // Muestra select de colonia
                $("#colonia-select").css('display', '')
                $("#colonia-select").removeAttr('disabled')
                $("#colonia-select").removeAttr('readonly')
                // Oculta input text de colonia
                $("#colonia-input").css('display', 'none')
                $("#colonia-input").removeAttr("readonly")
                $("#colonia-input").attr('disabled', true)

                //$("#validar-codigo-postal").css('cursor', 'not-allowed')


            })
        } else {
            // Muestra error
            $("#codigo-postal-error").text("El código postal es inválido.")
        }
    })

    // Evento de modificacion de input codigo postal
    $("#codigo-postal").on('input', function (e) {
        // Cada vez que modifique el valor del codigo postal, eliminara cualquier error visible
        // y eliminara cualquier valor de los campos de texto del domicilio
        $("#codigo-postal-error").text("")
        // Muestra select de colonia
        $("#colonia-select").empty()
        $("#colonia-select").attr("readonly", true)
        $("#colonia-select").css('display', '')
        // Oculta input text de colonia
        $("#colonia-input").css('display', 'none')
        $("#colonia-input").removeAttr("readonly")
        $("#colonia-input").attr('disabled', true)

        $("#municipio-ciudad").val("")
        $("#entidad-federativa").val("")
        // Vuelve a activar el boton de verificacion
        $("#validar-codigo-postal").attr('disabled', false)
        //$("#validar-codigo-postal").css('cursor', 'pointer')

        // Cuando cambie el codigo postal del domicilio comercial, desactivara el boton de copiar
        $("#copiar-domicilio-fiscal").prop('disabled', true)
    })

    // ------ Validacion código postal fiscal -----

    // Evento de boton para validacion
    $("#validar-codigo-postal-fiscal").on('click', function () {
        //alert("click")
        // Verifica si el codigo postal es valido
        let value = String($("#codigo-postal-fiscal").val())
        //alert(value.length)
        if (value.length == 5) {
            // Desactiva el boton temporalmente
            $("#validar-codigo-postal-fiscal").attr('disabled', true)

            // Muestra datos
            fetch(`${API}/obtener-info-cp?` + new URLSearchParams({
                cp: value
            })).then((response) => {
                return response.json()
                /*
                if (response.ok) {

                }
                return Promise.reject(response);
                */
            }).then((responseJson) => {
                //let jsonResult = JSON.parse(responseJson)
                let jsonResult = responseJson
                // Verificara si hubo error de parte de la API
                if (jsonResult["error"]) {
                    showFailAlert("Ocurrio un error con la API (Codigo " + jsonResult["code_error"] + ")", jsonResult["error_message"])
                }
                // Aqui obtendra los valores de la respuesta de el CP
                let response = jsonResult["response"]

                // Entidad federativa
                $("#entidad-federativa-fiscal").val(response["estado"])
                // Municipio
                $("#municipio-ciudad-fiscal").val(response["municipio"])

                // Colonias
                $("#colonia-fiscal-select").append($('<option>', { // Agrega elemento placeholder
                    value: "",
                    text: "Seleccione una colonia",
                    selected: true
                }))
                // Agrega colonias
                $.each(response["asentamiento"], function (i, asentamiento) {
                    $("#colonia-fiscal-select").append($('<option>', {
                        value: asentamiento,
                        text: asentamiento
                    }))
                })

                // Muestra select de colonia
                $("#colonia-fiscal-select").css('display', '')
                $("#colonia-fiscal-select").removeAttr('disabled')
                $("#colonia-fiscal-select").removeAttr("readonly")
                // Oculta input text de colonia
                $("#colonia-fiscal-input").css('display', 'none')
                $("#colonia-fiscal-input").removeAttr("readonly")
                $("#colonia-fiscal-input").attr('disabled', true)


                //$("#validar-codigo-postal").css('cursor', 'not-allowed')


            })
        } else {
            // Muestra error
            $("#codigo-postal-fiscal-error").text("El código postal es inválido.")
        }
    })

    // Evento de modificacion de input codigo postal
    $("#codigo-postal-fiscal").on('input', function (e) {
        // Cada vez que modifique el valor del codigo postal, eliminara cualquier error visible
        // y eliminara cualquier valor de los campos de texto del domicilio
        $("#codigo-postal-fiscal-error").text("")
        // Muestra select de colonia
        $("#colonia-fiscal-select").empty()
        $("#colonia-fiscal-select").attr("readonly", true)
        $("#colonia-fiscal-select").css('display', '')
        // Oculta input text de colonia
        $("#colonia-fiscal-input").css('display', 'none')
        $("#colonia-fiscal-input").removeAttr("readonly")
        $("#colonia-fiscal-input").attr('disabled', true)

        $("#municipio-ciudad-fiscal").val("")
        $("#entidad-federativa-fiscal").val("")
        // Vuelve a activar el boton de verificacion
        $("#validar-codigo-postal-fiscal").attr('disabled', false)
        //$("#validar-codigo-postal").css('cursor', 'pointer')
    })

    // --- Evento de seleccion de colonia de domicilio comercial -----
    $("#colonia-select").on('change', function (evt) {
        // Cuando se selecciona una colonia, habilitara el botón de 'Copiar a domicilio fiscal'
        let value = evt.target.value
        let disabled = value == null || value == '' || value == undefined || value == ""
        $("#copiar-domicilio-fiscal").prop('disabled', disabled)
    })

    // ----- Evento de copiar domicilio comercial al domicilio fiscal------
    $("#copiar-domicilio-fiscal").on('click', function () {
        // Obtiene los valores del domicilio comercial
        let calleNumero = $("#calle-numero").val()
        let codigoPostal = $("#codigo-postal").val()
        let colonia = $('#colonia-select').val() || null
        if (colonia == null)
            colonia = $("#colonia-input").val() || ""
        let municipio = $("#municipio-ciudad").val()
        let entidadFederativa = $("#entidad-federativa").val()

        // Datos para razon social de persona fisica
        let primerNombre = $("#primer-nombre").val() || ""
        let segundoNombre = $("#segundo-nombre").val() || ""
        let apellidoPaterno = $("#apellido-paterno").val() || ""
        let apellidoMaterno = $("#apellido-materno").val() || ""

        let razonSocialFiscal = `${primerNombre} ${segundoNombre} ${apellidoPaterno} ${apellidoMaterno}`

        // Copia la razon social fiscal para una persona fisica
        $("#razon-social-fiscal").val(razonSocialFiscal)

        // Oculta select de colonia
        $("#colonia-fiscal-select").empty()
        //$("#colonia-fiscal-select").attr("readonly", true)
        $("#colonia-fiscal-select").attr("disabled", true)
        $("#colonia-fiscal-select").css('display', 'none')
        // Muestra input text de colonia
        $("#colonia-fiscal-input").css('display', '')
        $("#colonia-fiscal-input").attr("readonly", true)

        // Copia los valores del domicilio comercial al domicilio fiscal
        $("#calle-numero-fiscal").val(calleNumero)
        $("#codigo-postal-fiscal").val(codigoPostal)
        $("#colonia-fiscal-input").val(colonia)
        $("#municipio-ciudad-fiscal").val(municipio)
        $("#entidad-federativa-fiscal").val(entidadFederativa)

        // Desactiva el boton de 'Validar codigo postal fiscal'
        $("#validar-codigo-postal-fiscal").attr('disabled', true)

        showToast("Se copió el domicilio correctamente.", "success")
    })

    // ---- Evento de copiar datos acta constituiva a datos de poder de representante legal
    $("#copiar-poder-r-legal").on('click', function () {
        // Obtiene los valores del acta constitutiva
        let aNumEscritura = $("#acta-constitutiva-num-escritura").val()
        let aFecha = $("#acta-constitutiva-fecha").val()
        let aNombreNotario = $("#acta-constitutiva-nombre-notario").val()
        let aLibro = $("#acta-constitutiva-libro").val()
        let aFolio = $("#acta-constitutiva-folio").val()
        let aNumNotaria = $("#acta-constitutiva-num-notaria").val()
        let aMunicipio = $("#acta-constitutiva-municipio").val()
        let aEstado = $("#acta-constitutiva-estado").val()


        // Copia los valores a poder del representante legal
        $("#poder-representante-legal-num-escritura").val(aNumEscritura)
        $("#poder-representante-legal-fecha").val(aFecha)
        $("#poder-representante-legal-nombre-notario").val(aNombreNotario)
        $("#poder-representante-legal-libro").val(aLibro)
        $("#poder-representante-legal-folio").val(aFolio)
        $("#poder-representante-legal-num-notaria").val(aNumNotaria)
        $("#poder-representante-legal-municipio").val(aMunicipio)
        $("#poder-representante-legal-estado").val(aEstado)

        showToast("Se copiaron los datos de acta constitutiva correctamente.", "success")
    })

    // ---- Evento de guardar contacto para el cliente ---
    $("#guardar-contacto-btn").on('click', function () {

        // Obtiene valores escritos del formulario
        let nombreContacto = document.getElementById("nombre-contacto");
        let puestoContacto = document.getElementById("puesto-contacto");
        let celularContacto = document.getElementById("celular-contacto");
        let correoContacto = document.getElementById("correo-contacto")

        // Verifica que haya completado todos los campos
        if (nombreContacto.value == "" || puestoContacto.value == "" ||
            celularContacto.value == "" || correoContacto.value == ""
        ) {
            showFailAlert("¡Atención!", "Debe completar todos los campos del contacto");
            return;
        }

        // Mostrara el contenedor de contactos
        $("#contactos-container").css('display', '')

        // Obtiene el posible indice del contacto que se va a modificar
        let indiceContactoModificarInput = document.getElementById("modificar-contacto-indice")
        let indiceContactoModificar = -1;

        if (indiceContactoModificarInput != null) {
            indiceContactoModificar = Number(indiceContactoModificarInput.value);
        }

        // ----------- Si el contacto se va a guardar por primera vez, ejecutara el siguiente bloque de codigo ---
        if (!contactosGuardadosId.includes(indiceContactoModificar)) {
            // **** Crea inputs hidden con los datos del contacto ingresado para agregarlos al formulario ****

            // Guarda localmente el indice del contacto
            let indiceContactoTemp = indiceContacto;

            // ---- Nombre de contacto ----
            let nombreContactoInputHidden = document.createElement("input");
            nombreContactoInputHidden.type = "hidden";
            nombreContactoInputHidden.name = "nombre-contacto[]";
            nombreContactoInputHidden.value = nombreContacto.value;
            nombreContactoInputHidden.id = "nombre-contacto-" + indiceContacto;

            // ---- Puesto de contacto ----
            let puestoContactoInputHidden = document.createElement("input");
            puestoContactoInputHidden.type = "hidden";
            puestoContactoInputHidden.name = "puesto-contacto[]";
            puestoContactoInputHidden.value = puestoContacto.value;
            puestoContactoInputHidden.id = "puesto-contacto-" + indiceContacto;

            // ---- Celular contacto ----
            let celularContactoInputHidden = document.createElement("input");
            celularContactoInputHidden.type = "hidden";
            celularContactoInputHidden.name = "celular-contacto[]";
            celularContactoInputHidden.value = celularContacto.value;
            celularContactoInputHidden.id = "celular-contacto-" + indiceContacto;

            // ---- Correo contacto ----
            let correoContactoInputHidden = document.createElement("input");
            correoContactoInputHidden.type = "hidden";
            correoContactoInputHidden.name = "correo-contacto[]";
            correoContactoInputHidden.value = correoContacto.value;
            correoContactoInputHidden.id = "correo-contacto-" + indiceContacto;

            // Agrega los inputs al formulario
            agregarProveedorForm.appendChild(nombreContactoInputHidden);
            agregarProveedorForm.appendChild(puestoContactoInputHidden);
            agregarProveedorForm.appendChild(celularContactoInputHidden);
            agregarProveedorForm.appendChild(correoContactoInputHidden);

            // Borra los datos de la tarjeta del formulario
            nombreContacto.value = "";
            puestoContacto.value = "";
            celularContacto.value = "";
            correoContacto.value = "";

            // Muestra en el listado de contactos, el nombre del contacto agregado recientemente

            // --- Crea el contenedor del elemento ---
            let containerElement = document.createElement("div");
            containerElement.setAttribute("data-index", indiceContacto); // establece el indice del contacto guardado
            containerElement.classList.add("list-item-container");
            containerElement.style.cursor = "pointer";

            // --- Crea el elemento de texto ----
            let textElement = document.createElement("p");
            textElement.id = "contacto-nombre-elemento-" + indiceContacto;
            textElement.classList.add("list-item-text");
            textElement.textContent = nombreContactoInputHidden.value;

            // --- Crea icono ---
            let iconElement = document.createElement("i")
            iconElement.classList.add("nav-icon")
            iconElement.classList.add('material-icons')
            iconElement.classList.add("list-item-icon");
            iconElement.appendChild(document.createTextNode("close"))
            iconElement.onclick = function () {
                // Elimina los input hidden
                agregarProveedorForm.removeChild(nombreContactoInputHidden);
                agregarProveedorForm.removeChild(puestoContactoInputHidden);
                agregarProveedorForm.removeChild(celularContactoInputHidden);
                agregarProveedorForm.removeChild(correoContactoInputHidden);

                // Verifica si actualmente se esta modificando la cuenta bancaria que se va a eliminar,
                // de ser asi, borrara los datos del formulario 
                if (indiceContactoTemp == indiceContactoModificacion) {
                    // Borra los valores que se muestran en la UI
                    nombreContacto.value = "";
                    puestoContacto.value = "";
                    celularContacto.value = "";
                    correoContacto.value = "";

                    // Cambia texto del boton
                    $("#guardar-contacto-btn").text("+ Agregar otro contacto");

                    // Reinicia el valor del indice del contacto actual que se estaba modificando
                    indiceContactoModificacion = undefined;

                    // Elimina el input que contiene el indice de la cuenta bancaria que se va a modificar(Si es que existe)
                    let modificarContactoIndiceInput = document.getElementById("modificar-contacto-indice")
                    if (modificarContactoIndiceInput != null) {
                        agregarProveedorForm.removeChild(modificarContactoIndiceInput)
                    }
                }

                // Elimina el contacto de la lista
                contactosContainer.removeChild(containerElement);

                // Si ya no hay mas cuentas bancarias, ocultara el texto del contenedor
                if (contactosContainer.childElementCount == 1) // Si solo contiene la etiqueta <label>
                    contactosContainer.style.display = "none";
            }


            // --- Agrega el elemento de texto al contenedor ---
            containerElement.appendChild(textElement);

            // --- Agrega elemento de icono --
            containerElement.appendChild(iconElement);

            // Agrega evento de click al contenedor del elemento
            containerElement.addEventListener("click", (evt) => {
                // Muestra en el formulario los valores del contacto especifico guardado
                let indiceContacto = evt.currentTarget.getAttribute("data-index"); // obtiene el indice del contacto guardado

                // Guarda el indice del contacto que se esta modificando
                indiceContactoModificacion = indiceContacto;

                // Obtiene los valores del contacto guardado
                let nombreContactoTemp = document.getElementById("nombre-contacto-" + indiceContacto).value;
                let puestoContactoTemp = document.getElementById("puesto-contacto-" + indiceContacto).value;
                let celularContactoTemp = document.getElementById("celular-contacto-" + indiceContacto).value;
                let correoContactoTemp = document.getElementById("correo-contacto-" + indiceContacto).value;


                // Establece los datos del contacto seleccionado
                nombreContacto.value = nombreContactoTemp;
                puestoContacto.value = puestoContactoTemp;
                celularContacto.value = celularContactoTemp;
                correoContacto.value = correoContactoTemp;

                // Modifica el texto del boton de accion de los contactos
                $("#guardar-contacto-btn").text("Modificar contacto")

                // Elimina los posibles inputs anteriores que pudo haber creado
                document.querySelectorAll("#modificar-contacto-indice").forEach((item) => {
                    agregarProveedorForm.removeChild(item);
                })

                // Crea input que contendra como valor el indice del contacto a modificar
                let modificarInput = document.createElement("input");
                modificarInput.type = "hidden";
                modificarInput.id = "modificar-contacto-indice";
                modificarInput.value = indiceContacto;
                agregarProveedorForm.appendChild(modificarInput);
            });


            // Agrega el contenedor del contacto al contenedor principal de los contactos
            contactosContainer.appendChild(containerElement);

            // Agrega el indice del contacto guardado a la lista de contactos guardados
            contactosGuardadosId.push(indiceContacto);

            // Aumenta en UNO el indice actual de contactos
            indiceContacto += 1;


        }

        // Si el contacto ya esta guardado, solamente actualizara los datos correspondientes
        if (contactosGuardadosId.includes(indiceContactoModificar)) {

            // Modifica los valores del formulario
            $("#nombre-contacto-" + indiceContactoModificar).val(nombreContacto.value);
            $("#puesto-contacto-" + indiceContactoModificar).val(puestoContacto.value);
            $("#celular-contacto-" + indiceContactoModificar).val(celularContacto.value);
            $("#correo-contacto-" + indiceContactoModificar).val(correoContacto.value);

            // Modifica el nombre de contacto de la lista de contactos
            document.getElementById("contacto-nombre-elemento-" + indiceContactoModificar).textContent = nombreContacto.value;

            // Despues de modificar, modifica el texto del boton de accion de los contactos
            $("#guardar-contacto-btn").text("+ Agregar otro contacto")

            // Borrara los valores del formulario
            nombreContacto.value = "";
            puestoContacto.value = "";
            celularContacto.value = "";
            correoContacto.value = "";

            agregarProveedorForm.removeChild(document.getElementById("modificar-contacto-indice"))
        }

    })


})