// provedores.js
// Archivo que contendra funciones utiles en los templates de 'agregar-provedor' y 'editar-provedor'

// Constante que representa a la aplicacion provedores en URL
const provedores = `${BASE_URL}provedores`


// Arreglo que guardara los archivos seleccionados de manera global
var filesSelected = []

// Contenedor de los archivos subidos
var contratosContainer = document.getElementById("contracts-container")

// Funcion que mostrara un contenedor con el nombre de un archivo seleccionado
function showFileSelected(file) {
    // Crea un container para el archivo seleccionado
    var div = document.createElement("div")

    div.setAttribute(
        "style",
        "background: none;border: 1px solid #cccccc;padding: 0.7em; padding-top:0.1em;padding-bottom:0;width:auto;margin-bottom: 15px; height: auto;display: flex;position:relative;"
    );

    // Crea un <p> para el nombre del archivo seleccionado
    var pName = document.createElement("p")
    pName.setAttribute(
        "style",
        `margin-top: 0px; font-size: 14px; color: #000000; font-weight: bold;
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
        width: 65%; 
        `
    );
    pName.textContent = `${file.name}`;

    // Crea otro <p> para el tamaño del archivo seleccionado
    /*
    var pSize = document.createElement("p")
    pSize.setAttribute(
        "style",
        `margin-top: 0px; font-size: 14px; color: #000000; font-weight: bold;`
    );
    pSize.textContent = `(${returnFileSize(file.size)})`;
    */

    // Crea otro <p> para mostrar la extension de el archivo seleccionado
    var pExtension = document.createElement("p")
    pExtension.setAttribute(
        "style",
        `margin-top: 0px; font-size: 14px; color: #000000; font-weight: bold;`
    )
    pExtension.textContent = `(${file.name.split('.').pop()})`

    // Inserta los elementos correspondientes
    //li.appendChild(document.createTextNode("Holaaa"))

    // Crea un <i> en donde se mostrara el icono
    var i = document.createElement("i")
    i.classList.add("nav-icon")
    i.classList.add('material-icons')
    i.setAttribute(
        "style",
        `font-size: 2em;cursor:pointer;
        flex: 2;
        text-align: end;
        vertical-align: middle;
        position: absolute;
        top: 50%;
        left: 90%;
        transform: translate(0,-50%);
        margin-left: 0.5em;`
    )
    i.appendChild(document.createTextNode("close"))

    // Evento onclick para la X
    i.onclick = function () {
        // Elimina el div
        contratosContainer.removeChild(div)
        // Elimina el archivo de la lista
        filesSelected = filesSelected.filter(e => e !== file)
        //filesSelected.splice(i,1)
        
        console.log(filesSelected)
    }

    div.appendChild(pName)
    div.appendChild(pExtension)
    //div.appendChild(pSize)
    div.appendChild(i)

    contratosContainer.insertBefore(div, null)
}


/** MODULO DE SUBIR ARCHIVOS DE CONTRATO */
window.onload = function () { // Cuando la ventana se cargue ejecutara este bloque de codigo
    // Checa el soporte de la API File

    if (window.File && window.FileList && window.FileReader) {
        // Variable donde se asignara el <input> tipo 'file' que servira para seleccionar archivos
        var filesInput = document.getElementById("contratos-files")
        filesInput.addEventListener("change", function (event) {
            // Objeto de FileList
            var files = event.target.files
            for (var i = 0; i < files.length; i++) {
                var file = files[i]
                // Si el archivo seleccionado, ya lo habia seleccionado antes, no hara nada
                if (!filesSelected.filter(e => e.name === file.name).length > 0) {
                    // Verifica que el archivo sea PDF
                    if (isPdf(file) || isWord(file)) {

                        // Agrega el archivo seleccionado a el array temporal
                        filesSelected.push(file)
                        // Muestra en la UI el archivo seleccionado
                        showFileSelected(file)
                    } else {
                        // Si no es PDF mostrara una alerta de error
                        showFailAlert("¡Atención!","Solo se permiten archivos PDF o WORD")
                    }
                }
            }
        })
    }
}

// ------------- 'editar-provedor.html' ------------------

// Funcion que recuperara cierto archivo de contrato pasado por parametro y lo mostrara en la UI 
async function recoverContratosFiles(url) {
    const fileObj = await createFileFromUrl(url)
    filesSelected.push(fileObj)
    showFileSelected(fileObj)
}

// Funcion que checara si el usuario subio almenos un contrato o marco alguna de las opciones de checkbox(editar-provedor.html)
function checkContratoFormEdit() {
    showLoadingAlert("Guardando cambios...")
    $("#submit-form-btn").prop('disabled', true) // Desactiva el boton de subir formulario
    if (filesSelected.length > 0) {
        // Agrega los posibles contratos seleccionados al input para enviarlos mediante el formulario
        setSelectedFilesToInput("contratos-files")
    }
    // Sube finalmente el formulario
    $("#editar-provedor-form").submit()
    
    // Si selecciono por lo menos un archivo, dejara registrar al provedor
    /*
    if (filesSelected.length > 0) {
        showLoadingAlert("Guardando cambios...")
        $("#submit-form-btn").prop('disabled', true) // Desactiva el boton de subir formulario
        // Agrega los posibles contratos seleccionados al input para enviarlos mediante el formulario
        setSelectedFilesToInput("contratos-files")
        // Sube finalmente el formulario
        $("#editar-provedor-form").submit()
    } else if ($("#contratoI").val() != "") { // De lo contrario, si selecciono almenos una opcion, de checkbox tambien dejara registrar al provedor
        showLoadingAlert("Guardando cambios...")
        $("#submit-form-btn").prop('disabled', true) // Desactiva el boton de subir formulario
        // Agrega los posibles contratos seleccionados al input para enviarlos mediante el formulario
        setSelectedFilesToInput("contratos-files")
        // Sube finalmente el formulario
        $("#editar-provedor-form").submit()
    } else {
        showFailAlert("¡Atencion!", "Debe subir un archivo de contrato o seleccionar alguna opción")
    }
    */
}

// Evento que se llamara cuando el formulario de 'editar-provedor.html' se empieze a subir
$('#editar-provedor-form').submit(function (evt) {
    // Evitara que se suba el formulario
    evt.preventDefault();
    checkContratoFormEdit()
});


/*
// Funcion que editara el cliente
function editClient() {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    // Crea un objeto FormData para enviarlo a travez de la peticion http con AJAX
    var formData = new FormData()
    // Adjunta cada archivo en el objeto FormData
    for (var i = 0; i < filesSelected.length; i++) {
        formData.append("contratos[]", filesSelected[i])
    }

    // ADJUNTA LOS DATOS DEL CLIENTE A REGISTRAR
    formData.append("rfc-cliente", $("[name=rfc-cliente]").val())
    formData.append("giro-empresa", $("[name=giro-empresa]").val())
    formData.append("nombre-empresa", $("[name=nombre-empresa]").val())
    formData.append("razon-social", $("[name=razon-social]").val())
    formData.append("domicilio-empresa", $("[name=domicilio-empresa]").val())
    formData.append("municipio", $("[name=municipio]").val())
    formData.append("estado", $("[name=estado]").val())
    formData.append("codigo-postal", $("[name=codigo-postal]").val())
    formData.append("telefono-contacto", $("[name=telefono-contacto]").val())
    formData.append("puesto-contacto", $("[name=puesto-contacto]").val())
    formData.append("contacto-empresa", $("[name=contacto-empresa]").val())
    formData.append("correo-contacto", $("[name=correo-contacto]").val())
    formData.append("num-colaboradores", $("[name=num-colaboradores]").val())
    formData.append("oficina-cliente", $("[name=oficina-cliente]").val())
    formData.append("fecha-contrato", $("[name=fecha-contrato]").val())
    formData.append("contratoI", $("[name=contratoI]").val())
    formData.append("estatus-cliente",$("[name=estatus-cliente]").val())
    formData.append("motivo-baja",$("[name=motivo-baja]").val())
    formData.append("img-cliente", $("[name=img-cliente]").prop('files')[0])
    $.ajax(
        {
            type: "POST",
            url: `${provedores}/editar-cliente/${$("#cliente-id").val()}`,
            processData: false,
            contentType: false,
            cache: false,
            data: formData,
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                if (data == "success") {
                    Swal.close()
                    Swal.fire(
                        {
                            title: "¡Exito!",
                            text: "Se modifico el cliente exitosamente.",
                            icon: 'success',
                            allowOutsideClick: false
                        }
                    ).then((result) => {
                        if (result.isConfirmed) {
                            location.replace(`${provedores}/listado-provedores`)
                        }
                    })
                } else {
                    Swal.close()
                    showFailAlert('¡Error!', data)
                    $("#submit-form-btn").prop('disabled', false)
                    
                }
            },
            error: function (a, b, c) {
                Swal.close()
                alert(a + " " + b + "" + c)
                console.log("errrrrorr")
            }
        }
    )
}
*/

// ---------------- agregar-provedor.html ----------------

// Funcion que enviara al backend los datos del cliente incluido los posibles contratos
/*
function registerClient() {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    // Crea un objeto FormData para enviarlo a travez de la peticion http con AJAX
    var formData = new FormData()
    // Adjunta cada archivo en el objeto FormData
    for (var i = 0; i < filesSelected.length; i++) {
        formData.append("contratos[]", filesSelected[i])
    }

    // ADJUNTA LOS DATOS DEL CLIENTE A REGISTRAR
    formData.append("rfc-cliente", $("[name=rfc-cliente]").val())
    formData.append("giro-empresa", $("[name=giro-empresa]").val())
    formData.append("nombre-empresa", $("[name=nombre-empresa]").val())
    formData.append("razon-social", $("[name=razon-social]").val())
    formData.append("domicilio-empresa", $("[name=domicilio-empresa]").val())
    formData.append("municipio", $("[name=municipio]").val())
    formData.append("estado", $("[name=estado]").val())

    formData.append("codigo-postal", $("[name=codigo-postal]").val())
    formData.append("telefono-contacto", $("[name=telefono-contacto]").val())
    formData.append("puesto-contacto", $("[name=puesto-contacto]").val())
    formData.append("contacto-empresa", $("[name=contacto-empresa]").val())
    formData.append("correo-contacto", $("[name=correo-contacto]").val())
    formData.append("num-colaboradores", $("[name=num-colaboradores]").val())
    formData.append("oficina-cliente", $("[name=oficina-cliente]").val())
    formData.append("fecha-contrato", $("[name=fecha-contrato]").val())
    formData.append("contratoI", $("[name=contratoI]").val())
    formData.append("img-cliente", $("[name=img-cliente]").prop('files')[0])
    console.log('process manager')
    $.ajax(
        {
            type: "POST",
            url: `${provedores}/agregar-cliente`,
            processData: false,
            contentType: false,
            cache: false,
            data: formData,
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                if (data == "success") {
                    Swal.close()
                    Swal.fire(
                        {
                            title: "¡Exito!",
                            text: "Se agrego al cliente exitosamente.",
                            icon: 'success',
                            allowOutsideClick: false
                        }
                    ).then((result) => {
                        if (result.isConfirmed) {
                            location.reload()
                        }
                    })
                } else {
                    // Vuelve a activar el Boton submit
                    $("#submit-form-btn").prop('disabled', false)
                    Swal.close()
                    showFailAlert('¡Error!', data)
                }
            },
            error: function (a, b, c) {
                Swal.close()
                alert(a + " " + b + "" + c)
                console.log("errrrrorr")
            }
        }
    )
}
*/

// Funcion que asignara los posibles contratos subidos a un input file en especifico
function setSelectedFilesToInput(inputId) {
    let dataTransfer = new DataTransfer()
    // Cargara las posibles imagenes de el vehiculo en el input multiple
    for (const file of filesSelected) {
        dataTransfer.items.add(file)
    }
    var inputFile = document.getElementById(inputId)
    inputFile.files = dataTransfer.files
}

// Funcion que checara si el usuario subio almenos un contrato o marco alguna de las opciones de checkbox(agregar-provedor.html)
function checkContratoForm() {
    showLoadingAlert("Registrando provedor...")
    $("#submit-form-btn").prop('disabled', true) // Desactiva el boton de subir formulario
    if (filesSelected.length > 0) {
        // Agrega los posibles contratos seleccionados al input para enviarlos mediante el formulario
        setSelectedFilesToInput("contratos-files")
    }
    // Sube finalmente el formulario
    $("#agregar-provedor-form").submit()
    
    
    // Si selecciono por lo menos un archivo, dejara registrar al provedor
    /*
    if (filesSelected.length > 0) {
        showLoadingAlert("Registrando provedor...")
        $("#submit-form-btn").prop('disabled', true) // Desactiva el boton de subir formulario
        // Agrega los posibles contratos seleccionados al input para enviarlos mediante el formulario
        setSelectedFilesToInput("contratos-files")
        // Sube finalmente el formulario
        $("#agregar-provedor-form").submit()
    } else if ($("#contratoI").val() != "") { // De lo contrario, si selecciono almenos una opcion, de checkbox tambien dejara registrar al provedor
        showLoadingAlert("Registrando provedor...")
        $("#submit-form-btn").prop('disabled', true) // Desactiva el boton de subir formulario
        // Agrega los posibles contratos seleccionados al input para enviarlos mediante el formulario
        setSelectedFilesToInput("contratos-files")
        // Sube finalmente el formulario
        $("#agregar-provedor-form").submit()
    } else {
        showFailAlert("¡Atencion!", "Debe subir un archivo de contrato o seleccionar alguna opción")
    }
    */
}


// Evento que se llamara cuando el formulario de 'agregar-cliente.html' se empieze  a subir
$("#agregar-provedor-form").on("submit", function (evt) {
    // Evitara que se suba el formulario
    evt.preventDefault();
    checkContratoForm()
})
/*
$('#cliente-form').submit(function (evt) {
    // Evitara que se suba el formulario
    evt.preventDefault();
    checkContratoForm()
});
*/

function clearAllSelectedFiles() {
    filesSelected = []
    console.log(filesSelected)
}

// Eventos que se llamaran cuando el usuario seleccione una opcion de checkbox en el contrato(agregar-provedor.html)
$("#checkContrato").change(function () {
    if (this.checked) {
        $('#contratos-files').prop('disabled', true);
        $('#contratos-files').prop('required', false);
        $('#contratos-files').val(null);
        $("#checkContratoNa").prop('disabled', true)
        $("#contratoI").val("En tramite")
        // Elimina todos los archivos y los divs 
        $("#contracts-container").empty()
        clearAllSelectedFiles()


    } else {
        $('#contratos-files').prop('disabled', false);
        $('#contratos-files').prop('required', true);
        $("#checkContratoNa").prop('disabled', false)
        $("#contratoI").val("")
    }
})
$("#checkContratoNa").change(function () {
    if (this.checked) {
        $('#contratos-files').prop('disabled', true);
        $('#contratos-files').prop('required', false);
        $('#contratos-files').val(null);
        $("#checkContrato").prop('disabled', true)
        $("#contratoI").val("N/A")
        // Elimina todos los archivos y los divs
        $("#contracts-container").empty()
        clearAllSelectedFiles()


    } else {
        $('#contratos-files').prop('disabled', false);
        $('#contratos-files').prop('required', true);
        $("#checkContrato").prop('disabled', false)
        $("#contratoI").val("")
    }
})
