// Funcion que exportara el listado a excel
async function exportarExcel(
) {
    var query = $("#query").val()
    var fechaServicio = $("#fecha-servicio").val()


    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${FLOTILLAS_PREFIX}/listado-servicios?` + new URLSearchParams({
            query: query,
            fecha_servicio: fechaServicio,
            exportar_excel: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte servicios mantenimiento.xlsx";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf() {
    var query = $("#query").val()
    var fechaServicio = $("#fecha-servicio").val()

    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${FLOTILLAS_PREFIX}/listado-servicios?` + new URLSearchParams({
            query: query,
            fecha_servicio: fechaServicio,
            exportar_pdf: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte servicios mantenimiento.pdf";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}
