
// Funcion que exportara el listado a excel
async function exportarExcel() {
    var query = $("#query").val()
    var fechaCompra = $("#fecha-compra").val()
    var fechaInstalacion = $("#fecha-instalacion").val()


    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${FLOTILLAS_PREFIX}/listado-refacciones?` + new URLSearchParams({
            query: query,
            fecha_compra: fechaCompra,
            fecha_instalacion: fechaInstalacion,
            exportar_excel: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte refacciones.xlsx";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf() {
    var query = $("#query").val()
    var fechaCompra = $("#fecha-compra").val()
    var fechaInstalacion = $("#fecha-instalacion").val()


    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${FLOTILLAS_PREFIX}/listado-refacciones?` + new URLSearchParams({
            query: query,
            fecha_compra: fechaCompra,
            fecha_instalacion: fechaInstalacion,
            exportar_pdf: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte refacciones.pdf";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}
