const PROVEDORES = `${BASE_URL}provedores`

// Mostrara un popup en donde el usuario podra cambiar el estatus del cliente
async function showChangeEstatusClienteAlert(
    idProvedor,
    estatusList
) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    // Convierte el listado de estatuses a un objeto JavaScript
    var estatusOptions = JSON.parse(estatusList)

    // Agrega los estatus correspondientes para seleccionar de la lista
    inputOptions = {}

    // Agrega los estatus a las opciones del select de la alerta
    $.each(estatusOptions, function (key,value) {
        inputOptions[value["fields"]["nombre"]] = value["fields"]["nombre"]
    })

    const { value: nuevo_estatus } = await Swal.fire({
        title: "Seleccione un nuevo estatus",
        input: "select",
        inputOptions: inputOptions,
        inputPlaceholder: "Selecciona un estatus",
        showCancelButton: true,
        inputValidator: (value) => {
            return new Promise((resolve) => {
                if (value == "") {
                    resolve("Seleccione un estatus")
                } else {
                    resolve()
                }
            })
        }
    });
    if (nuevo_estatus) {
        if (nuevo_estatus == "Activo")
            changeEstatus(idProvedor, nuevo_estatus)
        if (nuevo_estatus == "Baja")
            mostrarMotivoBaja(idProvedor)
            
    }
}

async function changeEstatusMotivoBaja(idProvedor, nuevo_estatus, motivoEstatus, fecha) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    $.ajax(
        {
            type: "POST",
            url: `${PROVEDORES}/cambiar-estatus-provedor`,
            data: {
                id_provedor: idProvedor,
                nuevo_estatus: nuevo_estatus,
                motivo: motivoEstatus,
                fecha_baja: fecha
            },
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el estatus exitosamente.",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + " " + b + "" + c)
            }
        }
    )
}

// Funcion que mostrara un Popup con un campo de texto en donde el usuario podra escribir
// el motivo de el estatus Baja de un colaborador
async function mostrarMotivoBaja(idProvedor) {
    // Obtiene la fecha de hoy
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0');
    var yyyy = today.getFullYear();
    today = yyyy + '-' + mm + '-' + dd;
    
    Swal.fire({
        title: "Baja",
        html: `
        <label>Motivo de baja</label>
        <textarea name="motivo-baja" required placeholder="Escriba el motivo de la baja" value="" class="form-control" id="motivo" cols="30" rows="5"></textarea>
        <label>Fecha de baja</label>
        <br>
        <input type="date" value="${today}" id="fecha" required class="form-control" ></input>
        `,
        confirmButtonText: 'Cambiar estatus'
    }).then((result) => {
        if (result.isConfirmed) {
            changeEstatusMotivoBaja(idProvedor, "Baja", $("#motivo").val(), $("#fecha").val())
        }
    })

}

function changeEstatus(idProvedor, nuevoEstatus) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    $.ajax(
        {
            type: "POST",
            url: `${PROVEDORES}/cambiar-estatus-provedor`,
            data: {
                id_provedor: idProvedor,
                nuevo_estatus: nuevoEstatus
            },
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el estatus exitosamente.",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + " " + b + "" + c)
            }
        }
    )
}


// Funcion que exportara el listado a excel
async function exportarExcel() {
    var query = $("#query").val()
    var estatus = $("#estatus").val()
    var oficina = $("#oficina").val()


    showLoadingAlert("Generando reporte...")
    const result = await fetch(
        `${PROVEDORES}/listado-provedores?` + new URLSearchParams({
            query: query,
            oficina: oficina,
            estatus: estatus,
            exportar_excel: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte provedores.xlsx";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf() {
    var query = $("#query").val()
    var estatus = $("#estatus").val()
    var oficina = $("#oficina").val()


    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${PROVEDORES}/listado-provedores?` + new URLSearchParams({
            query: query,
            oficina: oficina,
            estatus: estatus,
            exportar_pdf: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte provedores.pdf";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

