// Funcion que exportara el listado a excel
async function exportarExcel() {
    var query = $("#query").val()
    var fechaGeneracion = $("#fecha-generacion").val()


    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${BASE_URL}colaboradores/historiales-gafete?` + new URLSearchParams({
            query: query,
            fecha_generacion: fechaGeneracion,
            exportar_excel: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte historiales de gafetes.xlsx";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf() {
    var query = $("#query").val()
    var fechaGeneracion = $("#fecha-generacion").val()


    showLoadingAlert("Generando reporte...")

    const result = await fetch(
        `${BASE_URL}colaboradores/historiales-gafete?` + new URLSearchParams({
            query: query,
            fecha_generacion: fechaGeneracion,
            exportar_pdf: "true"
        }),
    )

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte historiales de gafetes.pdf";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}
