const CLIENTES_PREFIX = `${BASE_URL}clientes`

// Funcion que eliminara un cliente
async function eliminarCliente(id) {
    // Pide al usuario que ingrese la contraseña
    requestPasswordTo({}, () => {
        var csrftoken = $("[name=csrfmiddlewaretoken]").val();

        // Muestra dialogo de confirmacion
        Swal.fire({
            title: "Eliminar cliente",
            text: "¿Estas seguro de eliminar el cliente?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            cancelButtonText: "Cancelar",
            confirmButtonText: "Si, eliminar!"
        }).then((result) => {
            if (result.isConfirmed) {
                showLoadingAlert("Eliminando cliente...")
                // Elimina el colaborador
                $.ajax({
                    type: "POST",
                    url: `${CLIENTES_PREFIX}/eliminar-cliente`,
                    data: {
                        id: id
                    },
                    headers: {
                        "X-CSRFToken": csrftoken
                    },
                    success: function (data) {
                        Swal.close()
                        showActionConfirmAlert("¡Exito!", "Se elimino el cliente correctamente", () => {
                            location.reload()
                        })
                    },
                    error: function (a, b, c) {
                        console.log(a, b, c)
                    }
                })
            }
        })



    })
}

// Mostrara un popup en donde el usuario podra cambiar el estatus del cliente
async function showChangeEstatusClienteAlert(
    idCliente,
    estatusList
) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    // Convierte el listado de estatuses a un objeto JavaScript
    var estatusOptions = JSON.parse(estatusList)

    // Agrega los estatus correspondientes para seleccionar de la lista
    inputOptions = {}

    // Agrega los estatus a las opciones del select de la alerta
    $.each(estatusOptions, function (key, value) {
        inputOptions[value["fields"]["nombre"]] = value["fields"]["nombre"]
    })

    const { value: nuevo_estatus } = await Swal.fire({
        title: "Seleccione un nuevo estatus",
        input: "select",
        inputOptions: inputOptions,
        inputPlaceholder: "Selecciona un estatus",
        showCancelButton: true,
        inputValidator: (value) => {
            return new Promise((resolve) => {
                if (value == "") {
                    resolve("Seleccione un estatus")
                } else {
                    resolve()
                }
            })
        }
    });
    if (nuevo_estatus) {
        if (nuevo_estatus == "Activo")
            changeEstatus(idCliente, nuevo_estatus)
        if (nuevo_estatus == "Baja")
            mostrarMotivoBaja(idCliente)
        if (nuevo_estatus == "Lista negra")
            mostrarMotivoListaNegra(idCliente)

    }
}



async function cambiarEstatusCliente(formData) {
    showLoadingAlert("Modificando estatus...")
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    $.ajax(
        {
            type: "POST",
            url: `${CLIENTES_PREFIX}/cambiar-estatus`,
            data: formData,
            headers: {
                "X-CSRFToken": csrftoken
            },
            processData: false,
            contentType: false,
            success: function (data) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el estatus exitosamente.",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + " " + b + "" + c)
            }
        }
    )
}

// Funcion que mostrara un Popup con un campo de texto en donde el usuario podra escribir
// el motivo de el estatus Baja de un colaborador
async function mostrarMotivoBaja(idCliente) {
    // Obtiene la fecha de hoy
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0');
    var yyyy = today.getFullYear();
    today = yyyy + '-' + mm + '-' + dd;

    Swal.fire({
        title: "Baja",
        html: `
        <label>Motivo de baja</label>
        <textarea name="motivo-baja" required placeholder="Escriba el motivo de la baja" value="" class="form-control" id="motivo" cols="30" rows="5"></textarea>
        <label>Fecha de baja</label>
        <br>
        <input type="date" value="${today}" id="fecha" required class="form-control" ></input>
        `,
        confirmButtonText: 'Cambiar estatus'
    }).then((result) => {
        if (result.isConfirmed) {
            let formData = new FormData()
            formData.append("motivo", $("#motivo").val())
            formData.append("fecha_baja", $("#fecha").val())
            formData.append("id_cliente", idCliente)
            formData.append("nuevo_estatus", "Baja")

            cambiarEstatusCliente(formData)
        }
    })

}

// Funcion que mostrara un Popup con un campo de texto en donde el usuario podra escribir
// el motivo de el estatus Baja de un colaborador
async function mostrarMotivoListaNegra(idCliente) {
    // Obtiene la fecha de hoy
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0');
    var yyyy = today.getFullYear();
    today = yyyy + '-' + mm + '-' + dd;

    Swal.fire({
        title: "Lista negra",
        html: `
        <label>Motivo de lista negra</label>
        <textarea name="motivo-lista-negra" required placeholder="Escriba el motivo de la lista negra" value="" class="form-control" id="motivo" cols="30" rows="5"></textarea>
        <label>Fecha de lista negra</label>
        <br>
        <input type="date" value="${today}" id="fecha" required class="form-control" ></input>
        `,
        confirmButtonText: 'Cambiar estatus'
    }).then((result) => {
        if (result.isConfirmed) {
            let formData = new FormData()
            formData.append("motivo_lista_negra", $("#motivo").val())
            formData.append("fecha_lista_negra", $("#fecha").val())
            formData.append("id_cliente", idCliente)
            formData.append("nuevo_estatus", "Lista negra")

            cambiarEstatusCliente(formData)
        }
    })
}

function changeEstatus(idCliente, nuevoEstatus) {
    var csrftoken = $("[name=csrfmiddlewaretoken]").val();

    $.ajax(
        {
            type: "POST",
            url: `${CLIENTES_PREFIX}/cambiar-estatus`,
            data: {
                id_cliente: idCliente,
                nuevo_estatus: nuevoEstatus
            },
            headers: {
                "X-CSRFToken": csrftoken
            },
            success: function (data) {
                Swal.fire(
                    {
                        title: "¡Exito!",
                        text: "Se modifico el estatus exitosamente.",
                        icon: 'success',
                        allowOutsideClick: false
                    }
                ).then((result) => {
                    if (result.isConfirmed) {
                        location.reload()
                    }
                })
            },
            error: function (a, b, c) {
                alert(a + " " + b + "" + c)
            }
        }
    )
}


// Funcion que exportara el listado a excel
async function exportarExcel(searchResponse) {
    showLoadingAlert("Generando reporte...")

    // Obtiene el tipo de persona 
    let tipoPersona = $("#tipo-persona").val() || "M"

    // Obtiene la respuesta de recuperacion de filtros y lo convierte a un objeto JavaScript
    let searchResponseO = ""

    // Lista de opciones de estatus seleccionadas
    let estatusListQuery = []

    // Lista de opciones de oficinas seleccionadas
    let oficinasListQuery = []

    if (searchResponse != null && searchResponse != "" && searchResponse != undefined) {
        searchResponseO = JSON.parse(searchResponse)
        estatusListQuery = searchResponseO["estatus_list_query"] || []
        oficinasListQuery = searchResponseO["oficinas_list_query"] || []
    }

    // Obtiene el criterio de busqueda
    var searchQuery = $("#search-query").val()

    // Obtiene el posible giro (Si es persona moral)
    let giro = $("#giro-query").val() || ""

    // Parametros de busqueda
    let params = {
        search_query: searchQuery,
        exportar_excel: "true",
        tipo_persona_query: tipoPersona
    }

    // Si el tipo de persona es 'Moral'
    if (tipoPersona == "M") {
        params.giro_query = giro
    }

    let url = `${CLIENTES_PREFIX}/listado-clientes?`
    let searchParams = new URLSearchParams(params)

    // Agrega el listado de estatus de filtros seleccionados a la URL para exportar excel

    for (let estatus of estatusListQuery) {
        //searchParams.append("estatus-query" + encodeURIComponent("[") + encodeURIComponent("]"), estatus)
        searchParams.append("estatus-query[]", estatus)
    }

    for (let oficina of oficinasListQuery) {
        //searchParams.append("oficinas-query" + encodeURIComponent("[") + encodeURIComponent("]"), oficina)
        searchParams.append("oficinas-query[]", oficina)
    }

    // Completa la URL
    url += searchParams.toString()

    console.log(url + searchParams.toString())

    const result = await fetch(url)

    let fileName = getFileNameFromResponse(result)

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = fileName;
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf(searchResponse) {
    showLoadingAlert("Generando reporte...")

    // Obtiene el tipo de persona 
    let tipoPersona = $("#tipo-persona").val() || "M"

    // Obtiene la respuesta de recuperacion de filtros y lo convierte a un objeto JavaScript
    let searchResponseO = ""

    // Lista de opciones de estatus seleccionadas
    let estatusListQuery = []

    // Lista de opciones de oficinas seleccionadas
    let oficinasListQuery = []

    if (searchResponse != null && searchResponse != "" && searchResponse != undefined) {
        searchResponseO = JSON.parse(searchResponse)
        estatusListQuery = searchResponseO["estatus_list_query"] || []
        oficinasListQuery = searchResponseO["oficinas_list_query"] || []
    }

    // Obtiene el criterio de busqueda
    var searchQuery = $("#search-query").val()

    // Obtiene el posible giro (Si es persona moral)
    let giro = $("#giro-query").val() || ""

    // Parametros de busqueda
    let params = {
        search_query: searchQuery,
        exportar_pdf: "true",
        tipo_persona_query: tipoPersona
    }

    // Si el tipo de persona es 'Moral'
    if (tipoPersona == "M") {
        params.giro_query = giro
    }

    let url = `${CLIENTES_PREFIX}/listado-clientes?`
    let searchParams = new URLSearchParams(params)

    // Agrega el listado de estatus de filtros seleccionados a la URL para exportar excel

    for (let estatus of estatusListQuery) {
        //searchParams.append("estatus-query" + encodeURIComponent("[") + encodeURIComponent("]"), estatus)
        searchParams.append("estatus-query[]", estatus)
    }

    for (let oficina of oficinasListQuery) {
        //searchParams.append("oficinas-query" + encodeURIComponent("[") + encodeURIComponent("]"), oficina)
        searchParams.append("oficinas-query[]", oficina)
    }

    // Completa la URL
    url += searchParams.toString()

    console.log(url + searchParams.toString())

    const result = await fetch(url)

    let fileName = getFileNameFromResponse(result)

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = fileName;
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

