// listado-empresas.js

const EMPRESAS_PREFIX = `${BASE_URL}empresas`

// Funcion que mostrara el listado de oficinas de un puesto de oficina
async function verOficinasEmpresa(idEmpresa) {
    let url = `${EMPRESAS_PREFIX}/obtener-oficinas-empresa?`
    url += new URLSearchParams({
        id: idEmpresa
    })

    let response = await fetch(url)

    if (!response.ok) {
        let error = await result.json()
        console.log(error)
        return;
    }

    let responseJson = await response.json()

    let oficinas = responseJson.oficinas

    var html = `
    <h2>Oficinas de la empresa</h2>
        <br>
        <table class="table table-striped table-hover">
            <tr>
                <th>Nombre de oficina</th>
            <tr>
    `

    // Key -> Contendra el nombre de la oficina
    $.each(oficinas, function (i, oficina) {
        html += `
            <tr>
                <td>${oficina}</td>
            </tr>
        `
    })

    html += `
        </table>
    `
    Swal.fire({
        html: html
    });

}

// Funcion que exportara el listado a excel
async function exportarExcel(searchResponse) {
    showLoadingAlert("Generando reporte...")

    // Obtiene el tipo de persona 
    let tipoPersona = $("#tipo-persona").val() || "M"

    // Obtiene la respuesta de recuperacion de filtros y lo convierte a un objeto JavaScript
    let searchResponseO = null

    if (searchResponse != null && searchResponse != "" && searchResponse != undefined) {
        searchResponseO = JSON.parse(searchResponse)
    }


    // Lista de opciones de estatus seleccionadas
    let estatusListQuery = []
    let oficinasListQuery = []

    if (searchResponseO != null) {
        estatusListQuery = searchResponseO["estatus_list_query"] || []

        // Lista de opciones de oficinas seleccionadas
        oficinasListQuery = searchResponseO["oficinas_list_query"] || []
    }

    // Obtiene el criterio de busqueda
    var searchQuery = $("#search-query").val()

    // Obtiene el posible giro (Si es persona moral)
    let giro = $("#giro-query").val() || ""

    // Parametros de busqueda
    let params = {
        search_query: searchQuery,
        exportar_excel: "true",
        tipo_persona_query: tipoPersona
    }

    // Si el tipo de persona es 'Moral'
    if (tipoPersona == "M") {
        params.giro_query = giro
    }

    let url = `${EMPRESAS_PREFIX}/listado-empresas?`
    let searchParams = new URLSearchParams(params)

    // Agrega el listado de estatus de filtros seleccionados a la URL para exportar excel

    for (let estatus of estatusListQuery) {
        //searchParams.append("estatus-query" + encodeURIComponent("[") + encodeURIComponent("]"), estatus)
        searchParams.append("estatus-query[]", estatus)
    }

    for (let oficina of oficinasListQuery) {
        //searchParams.append("oficinas-query" + encodeURIComponent("[") + encodeURIComponent("]"), oficina)
        searchParams.append("oficinas-query[]", oficina)
    }

    // Completa la URL
    url += searchParams.toString()

    console.log(url + searchParams.toString())

    const result = await fetch(url)

    let fileName = getFileNameFromResponse(result)

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = fileName;
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara el listado a PDF
async function exportarPdf(searchResponse) {
    showLoadingAlert("Generando reporte...")

    // Obtiene el tipo de persona 
    let tipoPersona = $("#tipo-persona").val() || "M"

    // Obtiene la respuesta de recuperacion de filtros y lo convierte a un objeto JavaScript
    let searchResponseO = null

    if (searchResponse != null && searchResponse != "" && searchResponse != undefined) {
        searchResponseO = JSON.parse(searchResponse)
    }


    // Lista de opciones de estatus seleccionadas
    let estatusListQuery = []
    let oficinasListQuery = []

    if (searchResponseO != null) {
        estatusListQuery = searchResponseO["estatus_list_query"] || []

        // Lista de opciones de oficinas seleccionadas
        oficinasListQuery = searchResponseO["oficinas_list_query"] || []
    }

    // Obtiene el criterio de busqueda
    var searchQuery = $("#search-query").val()

    // Obtiene el posible giro (Si es persona moral)
    let giro = $("#giro-query").val() || ""

    // Parametros de busqueda
    let params = {
        search_query: searchQuery,
        exportar_pdf: "true",
        tipo_persona_query: tipoPersona
    }

    // Si el tipo de persona es 'Moral'
    if (tipoPersona == "M") {
        params.giro_query = giro
    }

    let url = `${EMPRESAS_PREFIX}/listado-empresas?`
    let searchParams = new URLSearchParams(params)

    // Agrega el listado de estatus de filtros seleccionados a la URL para exportar excel

    for (let estatus of estatusListQuery) {
        //searchParams.append("estatus-query" + encodeURIComponent("[") + encodeURIComponent("]"), estatus)
        searchParams.append("estatus-query[]", estatus)
    }

    for (let oficina of oficinasListQuery) {
        //searchParams.append("oficinas-query" + encodeURIComponent("[") + encodeURIComponent("]"), oficina)
        searchParams.append("oficinas-query[]", oficina)
    }

    // Completa la URL
    url += searchParams.toString()

    console.log(url + searchParams.toString())

    const result = await fetch(url)

    let fileName = getFileNameFromResponse(result)

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = fileName;
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}
