// ** Subida de fotografias de el vehiculo **

// Representa el numero de imagenes maximas que puede subir el usuario de un vehiculo
const MAX_IMAGES = 5
// Representa el tama�0�9o maximo(En MegaBytes) que puede tener una imagen de el vehiculo
const MAX_IMAGE_SIZE = 10

// Arreglo que guardara las imagenes seleccionadas de manera global
var filesSelected = []

// Funcion que verificara si el usuario cumple el numero permitido de imagenes(Cuando se clickee el input file)
function verifyLimitImages(event) {

    if (filesSelected.length == MAX_IMAGES) {
        event.preventDefault()
        showWarningAlert("�0�3Aviso!", `Solo se permiten subir maximo ${MAX_IMAGES} fotografias.`)
    }

}


// Funcion eliminara una imagen seleccionada del incidente de la lista
function onRemoveImgBtnClick(file) {
    // Elimina la imagen seleccionada de la lista
    filesSelected = filesSelected.filter(e => e !== file)

    // Cada vez que remueva una imagen, decrementara el contador de imagenes seleccionadas
    $("#img-counter").text(`${filesSelected.length}/${MAX_IMAGES}`)

    // Verificara el numero de imagenes que estan en la lista actualmente.
    // Si hay cero, mostrara la leyenda de 'No hay fotografias'
    if (filesSelected.length == 0) {
        $("#no-photos-vehiculo").fadeIn(300)
    }
}


// Funcion que mostrara la imagen subida en la UI
function showImageSelected(file) {
    // Cada vez que seleccione una imagen, aumentara el contador de imagenes seleccionadas
    $("#img-counter").text(`${filesSelected.length}/${MAX_IMAGES}`)

    // Ocultara la leyenda que dice 'No hay fotografias', ya que selecciono una fotografia
    $("#no-photos-vehiculo").hide()

    // Crea el contenedor para el <img>
    let containerImg = jQuery('<div>', {
        class: "selector-container-img"
    })

    // Crea el boton de "remover imagen" para la imagen de el incidente
    let removeBtn = jQuery('<i>', {
        class: "remove-img-btn-selector"
    })
    removeBtn.addClass("material-icons md-18")
    removeBtn.text("close")

    // Crea el elemento <a> para mostrar el <img> en forma modal(En un popup)
    let modalImgContainer = jQuery('<a>', {
        class: "pop"
    })
    modalImgContainer.attr('href', "#")

    // Crea el elemento <img>
    var img = jQuery('<img>', {
        class: 'selector-img'
    })
    img.addClass("img-thumbnail")
    //img.addClass("")
    // Leera la imagen seleccionada con este objeto
    var reader = new FileReader();
    reader.onload = function (e) {
        img.attr('src', e.target.result);
    }
    reader.readAsDataURL(file);

    // Agrega el <img> como elemento hijo del contenedor <a>(Se usara para mostrar el popup con la imagen)
    modalImgContainer.append(img)
    // Agrega el contenedor modal <a> como hijo del contenedor <div>
    containerImg.append(modalImgContainer)

    // Agrega el boton de remover como elemento hijo del contenedor <div>
    containerImg.append(removeBtn)

    // Cuando el usuario clickee el boton de remover imagen, removera la imagen correspondiente
    removeBtn.click(function () {
        //containerImg.remove() // Ocultara la imagen correspondiente
        containerImg.fadeOut(300, function () { $(this).remove(); })
        onRemoveImgBtnClick(file) // Eliminara la imagen seleccionada de la lista
    })

    containerImg.appendTo("#vehiculo-img-container")

}

window.onload = function () { // Cuando la ventana se cargue, ejecutara este bloque de codigo
    // Checa el soporte de la API File
    if (window.File && window.FileList && window.FileReader) {
        // Guarda el input de donde el usuario subira las fotos del incidente
        let inputFile = $("#selector-img-input") // Input type File
        inputFile.change(function (event) {
            console.log("cambio el input file")
            // Objeto de FileList
            var files = event.target.files
            for (var i = 0; i < files.length; i++) {
                var file = files[i]
                // Si la imagen seleccionada, ya la habia seleccionado antes, no hara nada
                if (!filesSelected.filter(e => e.name === file.name).length > 0) {

                    // Verifica que el archivo sea PNG,JPEG,WEBP,JPG
                    if (isImage(file)) {
                        // Verificara que el archivo no sobrepase los 10 MB
                        if (isFileSizeValid(file, MAX_IMAGE_SIZE)) {

                            // Verificara el total de imagenes que ha subido el usuario
                            // si se va a pasar de el limite, no mostrara la imagen
                            if (filesSelected.length < MAX_IMAGES) {

                                // Agrega el archivo seleccionado a el array temporal
                                filesSelected.push(file)
                                // Muestra en la UI la imagen seleccionada
                                showImageSelected(file)
                            } else {
                                showWarningAlert("�0�3Aviso!", `Solo se permiten subir maximo ${MAX_IMAGES} fotografias.`)
                            }
                        } else {
                            showWarningAlert("�0�3Aviso!", `La imagen debe pesar menos de ${MAX_IMAGE_SIZE} MegaBytes(MB)`)
                        }
                    } else {
                        // Si no es PDF mostrara una alerta de error
                        showFailAlert("�0�3Atenci��n!", "Solo se permiten archivos PNG,JPEG o WEBP")
                    }
                } else {
                    console.log("hey ya lo selecciono")
                }
            }
            // Al final limpiara el input de tipo File
            inputFile.val(null)
        })
    } else {
        console.log("API NO DISPONIBLE")
    }
}

// Funcion que recuperara las posibles fotografias de el vehiculo(Una por una pasadas por parametro)
async function obtenerFotoVehiculo(photoUrl) {

    const fileObj = await createFileFromUrl(`..${BASE_STATIC_URL}` + photoUrl)
    filesSelected.push(fileObj)
    showImageSelected(fileObj)
}

function onFormSubmited(event) {
    // Cargara las posibles imagenes de el vehiculo en el input multiple
    let dataTransfer = new DataTransfer()
    for (const file of filesSelected) {
        dataTransfer.items.add(file)
    }
    var inputFile = document.getElementById("selector-img-input")
    inputFile.files = dataTransfer.files

    // Al subir el formulario, mostrara una alerta de carga
    showLoadingAlert("Guardando cambios...")
}

// Funcion que se invocara cuando el usuario presione el checkbox de 'No aplica' para la instituci��n financiera
function onInstitucionFinancieraChecked(isChecked) {
    if (isChecked) {
        $("#institucion-financiera").prop('readonly', true);
        $("#institucion-financiera").val("No aplica")
    } else {
        $("#institucion-financiera").prop('readonly', false);
        $("#institucion-financiera").val("")
    }
}