// editar-colaborador.js

const COLABORADORES = `${BASE_URL}colaboradores`
const API = `${BASE_URL}api`

const NO_APLICA_N_A = "N/A(No aplica)"

// Indica si se inicializo el puesto
var initPuesto = false

$(document).ready(function () {
    // ----- Numero de cartilla militar -------
    $("#check-cartilla-militar-si").on('change', function () {
        if (this.checked) {
            // Activa el input
            $("#cartilla-militar").attr('readonly', false)
            // Establece el valor en el input
            $("#cartilla-militar").val("")
            // Desactiva el checked de el check contrario
            $("#check-cartilla-militar-no").prop('checked', false)

        } else {
            // Desactiva el input
            $("#cartilla-militar").attr('readonly', true)
            // Establece el valor en el input
            $("#cartilla-militar").val(NO_APLICA_N_A)
            // Activa el checked de el check contrario
            $("#check-cartilla-militar-no").prop('checked', true)
        }
    })
    $("#check-cartilla-militar-no").on('change', function () {
        if (this.checked) {
            // Desactiva el input
            $("#cartilla-militar").attr('readonly', true)
            // Establece el valor en el input
            $("#cartilla-militar").val(NO_APLICA_N_A)
            // Desactiva el checked de el check contrario
            $("#check-cartilla-militar-si").prop('checked', false)
        } else {
            // Activa el input
            $("#cartilla-militar").attr('readonly', false)
            // Establece el valor en el input
            $("#cartilla-militar").val("")
            // Activa el checked de el check contrario
            $("#check-cartilla-militar-si").prop('checked', true)
        }
    })

    // ----- Credito infonavit -------
    $("#check-credito-info-si").on('change', function () {
        if (this.checked) {
            // Activa el input
            $("#cinfonavit").attr('readonly', false)
            // Establece el valor en el input
            $("#cinfonavit").val("")
            // Desactiva el checked de el check contrario
            $("#check-credito-info-no").prop('checked', false)
        } else {
            // Desactiva el input
            $("#cinfonavit").attr('readonly', true)
            // Establece el valor en el input
            $("#cinfonavit").val(NO_APLICA_N_A)
            // Activa el checked de el check contrario
            $("#check-credito-info-no").prop('checked', true)
        }
    })
    $("#check-credito-info-no").on('change', function () {
        if (this.checked) {
            // Desactiva el input
            $("#cinfonavit").attr('readonly', true)
            // Establece el valor en el input
            $("#cinfonavit").val(NO_APLICA_N_A)
            // Desactiva el checked de el check contrario
            $("#check-credito-info-si").prop('checked', false)
        } else {
            // Activa el input
            $("#cinfonavit").attr('readonly', false)
            // Establece el valor en el input
            $("#cinfonavit").val("")
            // Activa el checked de el check contrario
            $("#check-credito-info-si").prop('checked', true)
        }
    })

    // ----- Credito fonacot ---------
    $("#check-credito-fonac-si").on('change', function () {
        if (this.checked) {
            // Activa el input
            $("#cfonacot").attr('readonly', false)
            // Establece valor en el input
            $("#cfonacot").val("")
            // Desactiva el checked en el check contrario
            $("#check-credito-fonac-no").prop('checked', false)
        } else {
            // Desactiva el input
            $("#cfonacot").attr('readonly', true)
            // Establece valor en el input
            $("#cfonacot").val(NO_APLICA_N_A)
            // Activa el checked en el check contrario
            $("#check-credito-fonac-no").prop('checked', true)
        }
    })
    $("#check-credito-fonac-no").on('change', function () {
        if (this.checked) {
            // Desactiva el input
            $("#cfonacot").attr('readonly', true)
            // Establece valor en el input
            $("#cfonacot").val(NO_APLICA_N_A)
            // Desactiva el checked en el check contrario
            $("#check-credito-fonac-si").prop('checked', false)
        } else {
            // Activa el input
            $("#cfonacot").attr('readonly', false)
            // Establece valor en el input
            $("#cfonacot").val("")
            // Activa el checked en el check contrario
            $("#check-credito-fonac-si").prop('checked', true)
        }
    })


    // ---------- Estatus IMSS -----
    $("#estatus-imss").on('change', function () {
        // Verfica que opcion esta seleccionada
        let selectedValue = this.value;
        if (selectedValue == "Activo") {
            // Muestra la fecha de alta de IMSS
            $("#fecha-alta-imss").prop('required', true)
            $("#fecha-alta-imss").css('display', "")
            $("#fecha-alta-imss-label").css('display', "")
            // Oculta la fecha de baja de IMSS
            $("#fecha-baja-imss").prop('required', false)
            $("#fecha-baja-imss").css('display', 'none')
            $("#fecha-baja-imss-label").css('display', 'none')


        } else if (selectedValue == "Inactivo") {
            // Muestra la fecha de baja de IMSS
            $("#fecha-baja-imss").prop('required', true)
            $("#fecha-baja-imss").css('display', '')
            $("#fecha-baja-imss-label").css('display', '')
            // Oculta la fecha de alta de IMSS
            $("#fecha-alta-imss").prop('required', false)
            $("#fecha-alta-imss").css('display', 'none')
            $("#fecha-alta-imss-label").css('display', 'none')

        } else {
            $("#fecha-alta-imss").prop('required', false)
            $("#fecha-alta-imss").css('display', 'none')
            $("#fecha-alta-imss-label").css('display', 'none')

            $("#fecha-baja-imss").prop('required', false)
            $("#fecha-baja-imss").css('display', 'none')
            $("#fecha-baja-imss-label").css('display', 'none')
        }
    })

    // ------------ Tipo licencia conducir -------------
    $("#tipo-licencia-conducir").on('change', function () {
        let value = this.value;
        if (value == "No aplica" || value == "") {
            $("#fecha-vigencia-licencia-conducir").prop('required', false)
        } else {
            $("#fecha-vigencia-licencia-conducir").prop('required', true)
        }
    })

    // --------- Subida de formulario principal -----------
    $("#editar-colaborador-form").submit(function (evt) {
        // Muestra alerta de carga
        showLoadingAlert("Modificando colaborador...")

        // --- Verifica que haya validado un código postal personal ---
        let municipio = $("#municipio-ciudad").val() || ""

        if (municipio == "") {
            evt.preventDefault()
            Swal.close()
            // Si no valido el codigo postal, mostrara una alerta de error
            showFailAlert("¡Atención!", "Debe validar el código postal personal y seleccionar una colonia.")
        }

        // --- Verifica que haya validado un código postal fiscal ----
        let municipioFiscal = $("#municipio-ciudad-fiscal").val() || ""

        if (municipioFiscal == "") {
            evt.preventDefault()
            Swal.close()
            // Si no valido el codigo postal fiscal, mostrara una alerta de error
            showFailAlert("¡Atención!", "Debe validar el código postal fiscal y seleccionar una colonia.")
        }



    })


    // ---------------- Validacion código postal personal --------------

    // Evento de boton para validacion
    $("#validar-codigo-postal").on('click', function () {
        //alert("click")
        // Verifica si el codigo postal es valido
        let value = String($("#codigo-postal").val())
        //alert(value.length)
        if (value.length == 5) {
            // Desactiva el boton temporalmente
            $("#validar-codigo-postal").attr('disabled', true)

            // Muestra datos
            fetch(`${API}/obtener-info-cp?` + new URLSearchParams({
                cp: value
            })).then((response) => {
                return response.json()
                /*
                if (response.ok) {

                }
                return Promise.reject(response);
                */
            }).then((responseJson) => {
                //let jsonResult = JSON.parse(responseJson)
                let jsonResult = responseJson
                // Verificara si hubo error de parte de la API
                if (jsonResult["error"]) {
                    showFailAlert("Ocurrio un error con la API (Codigo " + jsonResult["code_error"] + ")", jsonResult["error_message"])
                }
                // Aqui obtendra los valores de la respuesta de el CP
                let response = jsonResult["response"]

                // Entidad federativa
                $("#entidad-federativa").val(response["estado"])
                // Municipio
                $("#municipio-ciudad").val(response["municipio"])

                // Colonias
                $("#colonia-select").append($('<option>', { // Agrega elemento placeholder
                    value: "",
                    text: "Seleccione una colonia",
                    selected: true
                }))
                // Agrega colonias
                $.each(response["asentamiento"], function (i, asentamiento) {
                    $("#colonia-select").append($('<option>', {
                        value: asentamiento,
                        text: asentamiento
                    }))
                })

                // Muestra select de colonia
                $("#colonia-select").css('display', '')
                $("#colonia-select").removeAttr('disabled')
                $("#colonia-select").removeAttr('readonly')
                // Oculta input text de colonia
                $("#colonia-input").css('display', 'none')
                $("#colonia-input").removeAttr("readonly")
                $("#colonia-input").attr('disabled', true)


                //$("#validar-codigo-postal").css('cursor', 'not-allowed')


            })
        } else {
            // Muestra error
            $("#codigo-postal-error").text("El código postal es inválido.")
        }
    })

    // Evento de modificacion de input codigo postal
    $("#codigo-postal").on('input', function (e) {
        // Cada vez que modifique el valor del codigo postal, eliminara cualquier error visible
        // y eliminara cualquier valor de los campos de texto del domicilio
        $("#codigo-postal-error").text("")
        // Muestra select de colonia
        $("#colonia-select").empty()
        $("#colonia-select").attr("readonly", true)
        $("#colonia-select").css('display', '')
        // Oculta input text de colonia
        $("#colonia-input").css('display', 'none')
        $("#colonia-input").removeAttr("readonly")
        $("#colonia-input").attr('disabled', true)

        $("#municipio-ciudad").val("")
        $("#entidad-federativa").val("")
        // Vuelve a activar el boton de verificacion
        $("#validar-codigo-postal").attr('disabled', false)
        //$("#validar-codigo-postal").css('cursor', 'pointer')

        // Cuando cambie el codigo postal del domicilio actual, desactivara el boton de copiar
        $("#copiar-domicilio-fiscal").prop('disabled', true)
    })

    // ------ Validacion código postal fiscal -----

    // Evento de boton para validacion
    $("#validar-codigo-postal-fiscal").on('click', function () {
        //alert("click")
        // Verifica si el codigo postal es valido
        let value = String($("#codigo-postal-fiscal").val())
        //alert(value.length)
        if (value.length == 5) {
            // Desactiva el boton temporalmente
            $("#validar-codigo-postal-fiscal").attr('disabled', true)

            // Muestra datos
            fetch(`${API}/obtener-info-cp?` + new URLSearchParams({
                cp: value
            })).then((response) => {
                return response.json()
                /*
                if (response.ok) {

                }
                return Promise.reject(response);
                */
            }).then((responseJson) => {
                //let jsonResult = JSON.parse(responseJson)
                let jsonResult = responseJson
                // Verificara si hubo error de parte de la API
                if (jsonResult["error"]) {
                    showFailAlert("Ocurrio un error con la API (Codigo " + jsonResult["code_error"] + ")", jsonResult["error_message"])
                }
                // Aqui obtendra los valores de la respuesta de el CP
                let response = jsonResult["response"]

                // Entidad federativa
                $("#entidad-federativa-fiscal").val(response["estado"])
                // Municipio
                $("#municipio-ciudad-fiscal").val(response["municipio"])

                // Colonias
                $("#colonia-fiscal-select").append($('<option>', { // Agrega elemento placeholder
                    value: "",
                    text: "Seleccione una colonia",
                    selected: true
                }))
                // Agrega colonias
                $.each(response["asentamiento"], function (i, asentamiento) {
                    $("#colonia-fiscal-select").append($('<option>', {
                        value: asentamiento,
                        text: asentamiento
                    }))
                })

                // Muestra select de colonia
                $("#colonia-fiscal-select").css('display', '')
                $("#colonia-fiscal-select").removeAttr('disabled')
                $("#colonia-fiscal-select").removeAttr('readonly')
                // Oculta input text de colonia
                $("#colonia-fiscal-input").css('display', 'none')
                $("#colonia-fiscal-input").removeAttr("readonly")
                $("#colonia-fiscal-input").attr('disabled', true)


                //$("#validar-codigo-postal").css('cursor', 'not-allowed')


            })
        } else {
            // Muestra error
            $("#codigo-postal-fiscal-error").text("El código postal es inválido.")
        }
    })

    // Evento de modificacion de input codigo postal
    $("#codigo-postal-fiscal").on('input', function (e) {
        // Cada vez que modifique el valor del codigo postal, eliminara cualquier error visible
        // y eliminara cualquier valor de los campos de texto del domicilio
        $("#codigo-postal-fiscal-error").text("")
        // Muestra select de colonia
        $("#colonia-fiscal-select").empty()
        $("#colonia-fiscal-select").attr("readonly", true)
        $("#colonia-fiscal-select").css('display', '')
        // Oculta input text de colonia
        $("#colonia-fiscal-input").css('display', 'none')
        $("#colonia-fiscal-input").removeAttr("readonly")
        $("#colonia-fiscal-input").attr('disabled', true)

        $("#municipio-ciudad-fiscal").val("")
        $("#entidad-federativa-fiscal").val("")
        // Vuelve a activar el boton de verificacion
        $("#validar-codigo-postal-fiscal").attr('disabled', false)
        //$("#validar-codigo-postal").css('cursor', 'pointer')
    })

    // --- Evento de seleccion de colonia de domicilio actual -----
    $("#colonia-select").on('change', function (evt) {
        // Cuando se selecciona una colonia, habilitara el botón de 'Copiar a domicilio fiscal'
        let value = evt.target.value
        let disabled = value == null || value == '' || value == undefined || value == ""
        $("#copiar-domicilio-fiscal").prop('disabled', disabled)
    })

    // ----- Evento de copiar domicilio comercial al domicilio fiscal------
    $("#copiar-domicilio-fiscal").on('click', function () {
        // Obtiene los valores del domicilio comercial
        let calleNumero = $("#calle-numero").val()
        let codigoPostal = $("#codigo-postal").val()
        let colonia = $('#colonia-select').val() || null
        if (colonia == null)
            colonia = $("#colonia-input").val() || ""
        let municipio = $("#municipio-ciudad").val()
        let entidadFederativa = $("#entidad-federativa").val()

        // Oculta select de colonia
        $("#colonia-fiscal-select").empty()
        //$("#colonia-fiscal-select").attr("readonly", true)
        $("#colonia-fiscal-select").attr("disabled", true)
        $("#colonia-fiscal-select").css('display', 'none')
        // Muestra input text de colonia
        $("#colonia-fiscal-input").css('display', '')
        $("#colonia-fiscal-input").attr("readonly", true)

        // Copia los valores del domicilio comercial al domicilio fiscal
        $("#calle-numero-fiscal").val(calleNumero)
        $("#codigo-postal-fiscal").val(codigoPostal)
        $("#colonia-fiscal-input").val(colonia)
        $("#municipio-ciudad-fiscal").val(municipio)
        $("#entidad-federativa-fiscal").val(entidadFederativa)

        // Desactiva el boton de 'Validar codigo postal fiscal'
        $("#validar-codigo-postal-fiscal").attr('disabled', true)

        showToast("Se copió el domicilio correctamente.", "success")
    })

    // ---- Evento de seleccion de oficina -----
    $("#oficina").on('change', async function (evt) {
        // ***** Cargar puestos ******
        let oficinaId = evt.target.value || null
        // <select> de puestos
        let puestosSelect = $("#puesto")
        // Cada vez que modifique la oficina, limpiara el select de puestos
        puestosSelect.empty()
        puestosSelect.append($("<option>", {
            text: "Seleccione un puesto",
            value: "",
            selected: true
        }))

        if (oficinaId != null) {
            // Realiza una peticion para obtener los puestos
            let url = `${COLABORADORES}/obtener-puestos-por-oficina?`
            url += `oficina_id=${oficinaId}`
            let request = await fetch(url, { headers: { "x-requested-with": "XMLHttpRequest" } })
            if (!request.ok) {
                console.log(request.json())
            }
            // Obtiene la respuesta en formato json
            let response = await request.json()

            // Obtiene los puestos de la respuesta
            let puestos = response.puestos

            console.log(puestos)

            // Agrega los puestos al select
            $.each(puestos, function (i, puesto_obj) {
                console.log("puesto_obj ->" + puesto_obj)
                console.log("index -> " + i)
                console.log("nombre -> " + puesto_obj.nombre)
                console.log("id -> " + puesto_obj.id)

                puestosSelect.append($("<option>", {
                    value: puesto_obj.id,
                    text: puesto_obj.nombre
                }))
            })

            // Si es la primera vez que entra a este script, inicializara el puesto
            if (!initPuesto) {
                //alert("puesto init id -> " + puestoId)
                // ***** Puesto ****
                $("#puesto").val(puestoId)
                initPuesto = !initPuesto
            }
        }
    })

    // Inicializaciones
    // ** Oficina **
    $("#oficina").change()

})

// ---- Estatus de colaborador ------
function hideEstatusBaja() {
    $("#motivoR").css('display', 'none')
    $("#motivo").prop('readonly', true)
    $("#motivo").prop('required', false)
    $("#motivo").val("")
    $("#fecha-baja").prop('required', false)
    $("#fecha-baja").prop('readonly', true)

}

function showEstatusBaja() {
    $("#motivoR").css('display', 'block')
    $("#motivo").prop('readonly', false)
    $("#motivo").prop('required', true)
    $("#fecha-baja").prop('required', true)
    $("#fecha-baja").prop('readonly', false)


}

function showEstatusListaNegra() {
    $("#motivoListaNegraR").css('display', 'block')
    $("#motivo-lista-negra").prop('readonly', false)
    $("#motivo-lista-negra").prop('required', true)
    $("#motivo-lista-negra").val("")


}

function hideEstatusListaNegra() {

    $("#motivoListaNegraR").css('display', 'none')
    $("#motivo-lista-negra").prop('readonly', true)
    $("#motivo-lista-negra").prop('required', false)
    $("#motivo-lista-negra").val("")



}

function showEstatusIncapacidad() {
    $("#incapacidadR").css('display', 'block')
    $("#incapacidadF").prop('readonly', false)
    $("#incapacidadF").prop('required', true)
    $("#incapacidad-fecha1").prop('readonly', false)
    $("#incapacidad-fecha1").prop('required', true)
    $("#incapacidad-fecha2").prop('readonly', false)
    $("#incapacidad-fecha2").prop('required', true)

}

function hideEstatusIncapacidad() {

    $("#incapacidadR").css('display', 'none')
    $("#incapacidadF").prop('readonly', true)
    $("#incapacidadF").prop('required', false)
    $("#incapacidad-fecha1").prop('readonly', true)
    $("#incapacidad-fecha1").prop('required', false)
    $("#incapacidad-fecha2").prop('readonly', true)
    $("#incapacidad-fecha2").prop('required', false)

}

function showEstatusVacaciones() {
    $("#vacacionesR").css('display', 'block')
    $("#vacaciones-fecha1").prop('readonly', false)
    $("#vacaciones-fecha1").prop('required', true)
    $("#vacaciones-fecha2").prop('readonly', false)
    $("#vacaciones-fecha2").prop('required', true)

}

function hideEstatusVacaciones() {
    $("#vacacionesR").css('display', 'none')
    $("#vacaciones-fecha1").prop('readonly', true)
    $("#vacaciones-fecha1").prop('required', false)
    $("#vacaciones-fecha2").prop('readonly', true)
    $("#vacaciones-fecha2").prop('required', false)

}



function onEstatusChange(valueEstatus) {
    jQuery(document).ready(function () {
        if (valueEstatus == "Baja") {
            /*
          $("#motivoR").css('display', 'block')
          $("#motivo").prop('readonly', false)
          $("#motivo").prop('required', true)
          $("#fecha-baja").prop('required',true)
          $("#fecha-baja").prop('readonly',false)
          */
            showEstatusBaja()

            /*
            $("#motivoListaNegraR").css('display', 'none')
            $("#motivo-lista-negra").prop('readonly', true)
            $("#motivo-lista-negra").prop('required', false)
            $("#motivo-lista-negra").val("")
            */
            hideEstatusListaNegra()
            hideEstatusIncapacidad()
            hideEstatusVacaciones()
            /*
            $("#incapacidadR").css('display', 'none')
            $("#incapacidadF").prop('readonly', true)
            $("#incapacidadF").prop('required', false)
            $("#incapacidad-fecha1").prop('readonly', true)
            $("#incapacidad-fecha1").prop('required', false)
            $("#incapacidad-fecha2").prop('readonly', true)
            $("#incapacidad-fecha2").prop('required', false)
            */
        } else if (valueEstatus == "Lista Negra") {
            showEstatusListaNegra()
            /*
            $("#motivoListaNegraR").css('display', 'block')
            $("#motivo-lista-negra").prop('readonly', false)
            $("#motivo-lista-negra").prop('required', true)
            */

            hideEstatusBaja()
            hideEstatusIncapacidad()
            hideEstatusVacaciones()

            /*
            $("#motivoR").css('display', 'none')
            $("#motivo").prop('readonly', true)
            $("#motivo").prop('required', false)
            $("#motivo").val("")
            $("#fecha-baja").prop('required', false)
            $("#fecha-baja").prop('readonly', true)
    
            $("#incapacidadR").css('display', 'none')
            $("#incapacidadF").prop('readonly', true)
            $("#incapacidadF").prop('required', false)
            $("#incapacidad-fecha1").prop('readonly', true)
            $("#incapacidad-fecha1").prop('required', false)
            $("#incapacidad-fecha2").prop('readonly', true)
            $("#incapacidad-fecha2").prop('required', false)
            */
        } else if (valueEstatus == "Incapacidad") {
            /*
            $("#incapacidadR").css('display', 'block')
            $("#incapacidadF").prop('readonly', false)
            $("#incapacidadF").prop('required', true)
            $("#incapacidad-fecha1").prop('readonly', false)
            $("#incapacidad-fecha1").prop('required', true)
            $("#incapacidad-fecha2").prop('readonly', false)
            $("#incapacidad-fecha2").prop('required', true)
            */

            showEstatusIncapacidad()
            hideEstatusBaja()
            hideEstatusListaNegra()
            hideEstatusVacaciones()

            /*
            $("#motivoListaNegraR").css('display', 'none')
            $("#motivo-lista-negra").prop('readonly', true)
            $("#motivo-lista-negra").prop('required', false)
    
            $("#motivoR").css('display', 'none')
            $("#motivo").prop('readonly', true)
            $("#motivo").prop('required', false)
            $("#motivo").val("")
            $("#fecha-baja").prop('required', false)
            $("#fecha-baja").prop('readonly', true)
            */
        } else if (valueEstatus == "Vacaciones") {
            showEstatusVacaciones()
            hideEstatusBaja()
            hideEstatusListaNegra()
            hideEstatusIncapacidad()
        } else {
            hideEstatusBaja()
            hideEstatusListaNegra()
            hideEstatusIncapacidad()
            hideEstatusVacaciones()

            /*
            $("#motivoListaNegraR").css('display', 'none')
            $("#motivo-lista-negra").prop('readonly', true)
            $("#motivo-lista-negra").prop('required', false)
            $("#motivo-lista-negra").val("")
    
            $("#motivoR").css('display', 'none')
            $("#motivo").prop('readonly', true)
            $("#motivo").prop('required', false)
            $("#motivo").val("")
            $("#fecha-baja").prop('required', false)
            $("#fecha-baja").prop('readonly', true)
    
            $("#incapacidadR").css('display', 'none')
            $("#incapacidadF").prop('readonly', true)
            $("#incapacidadF").prop('required', false)
            $("#incapacidad-fecha1").prop('readonly', true)
            $("#incapacidad-fecha1").prop('required', false)
            $("#incapacidad-fecha2").prop('readonly', true)
            $("#incapacidad-fecha2").prop('required', false)
            */
        }

    })
    /*
    if (valueEstatus == "Baja") {
      $("#motivoR").css('display', 'block')
      $("#motivo").prop('readonly', false)
      $("#motivo").prop('required', true)
    } else {
      $("#motivoR").css('display', 'none')
      $("#motivo").prop('readonly', true)
      $("#motivo").prop('required', false)
      $("#motivo").val("")
    }
    */



}