// validar-rfc.js

CLIENTES = `${BASE_URL}clientes`

$(document).ready(function () {
    $("#asignar-oficinas").on('click', function () {
        showLoadingAlert('Asignando oficinas...')

        // Obtiene el id del cliente
        let idCliente = $("#id-cliente").val()

        // Objeto que almacenara los parametros en formato {clave: valor}
        let searchQuery = new URLSearchParams({
            id_cliente: idCliente
        })

        // Obtiene las oficinas seleccionadas
        let oficinaListItems = document.querySelectorAll(".checked.oficina-item")

        oficinaListItems.forEach(item => {
            // Obtiene el texto de el item
            let textContent = item.getElementsByClassName("item-text")[0].textContent
            // Agrega la oficina a los parametros
            searchQuery.append("oficinas-items[]", textContent)
        })

        var csrftoken = $("[name=csrfmiddlewaretoken]").val();

        $.ajax({
            type: "POST",
            url: `${CLIENTES}/asignar-oficinas`,
            headers: {
                "X-CSRFToken": csrftoken
            },
            data: searchQuery,
            processData: false,
            contentType: false,
            success: function (data) {
                showActionConfirmAlert('¡Exito!', "Se asignaron los oficinas al cliente correctamente", () => {
                    location.reload()
                })
            },
            error: function (a, b, c) {
                console.log(a, b, c)
            }
        })
    })
})