// admin-puestos-cliente.js

CLIENTES = `${BASE_URL}clientes`


$(document).ready(function () {
    // ----- Multiselect OFICINAS -------
    let oficinaSelectBtn = document.getElementById("oficina-select-btn")
    //const selectBtn = document.querySelector(".select-btn");
    //const oficinaItems = document.querySelectorAll(".item");
    let oficinaItems = document.querySelectorAll(".oficina-item")

    // Item default de el multiselect de oficinas
    const DEFAULT_OFICINAS_ITEM = "Todas las oficinas"

    oficinaSelectBtn.addEventListener("click", () => {
        oficinaSelectBtn.classList.toggle("open")
    })

    oficinaItems.forEach(item => {
        item.addEventListener("click", () => {
            item.classList.toggle("checked")

            //let checked = document.querySelectorAll(".checked"),
            //let checked = document.querySelectorAll('li[class="checked"][class="oficina-item"]')
            let checked = document.querySelectorAll(".checked.oficina-item")
            btnText = document.querySelector(".oficina-btn-text")


            if (checked && checked.length > 0) {
                btnText.innerText = `${checked.length} seleccionadas`
            } else {
                btnText.innerText = `Selecciona oficinas`
            }

            // Obtiene el texto de el primer elemento de la lista
            let itemText = item.getElementsByClassName("item-text")[0].textContent

            // Si selecciona el item (Todas las oficinas) marcara todas las opciones
            if (itemText == DEFAULT_OFICINAS_ITEM && item.classList.contains("checked") && checked.length >= 1) {
                oficinaItems.forEach(item => {
                    /*
                    let itemText = item.getElementsByClassName("item-text")[0].textContent
                    if (itemText != DEFAULT_OFICINAS_ITEM) {
                        item.classList.remove("checked")
                        btnText.innerText = DEFAULT_OFICINAS_ITEM
                    }
                        */
                    item.classList.add("checked")
                    btnText.innerText = DEFAULT_OFICINAS_ITEM
                })
            }

            // Si el usuario desmarca la opcion 'Todas las oficinas' desmarcara todas las opciones
            if (itemText == DEFAULT_OFICINAS_ITEM && !item.classList.contains("checked")) {
                oficinaItems.forEach(item => {
                    let itemText = item.getElementsByClassName("item-text")[0].textContent
                    if (itemText != DEFAULT_OFICINAS_ITEM) {
                        item.classList.remove("checked")
                        btnText.innerText = DEFAULT_OFICINAS_ITEM
                    }
                })
                // Establece texto en boton
                btnText.innerText = `Selecciona oficinas`
            }

            // Si el usuario desmarca alguna otra opcion que no sea 'Todas las oficinas' desmarcara la opcion de 'Todas las oficinas'
            // (Si esta marcada)
            if (itemText != DEFAULT_OFICINAS_ITEM && !item.classList.contains("checked")) {
                let defaultOficinaItem = oficinaItems[0] // 'Todas las oficinas'
                defaultOficinaItem.classList.remove("checked")

                // Despues de remover la opcion de 'Todas las oficinas',
                // Muestra el numero de opciones seleccionadas (Solo si hay almenos una)
                if (checked && checked.length > 0) {
                    checked = document.querySelectorAll(".checked.oficina-item")
                    btnText.innerText = `${checked.length} seleccionadas`
                }
            }

            // Si selecciona la primera opción(Todas las oficinas) y solo hay una opcion
            // seleccionada, mostrara otro texto de el boton
            if (checked && checked.length == 1 && itemText == DEFAULT_OFICINAS_ITEM) {
                btnText.innerText = DEFAULT_OFICINAS_ITEM
            }
        })
    })

    let form = document.querySelector("form")

    // Aqui agregara un evento de cuando se realize una busqueda(Suba el formulario)
    //$("#search-form").submit(function (evt) {
    form.addEventListener("submit", function (evt) {
        showLoadingAlert('Registrando puesto...')

        /*
        // Cuando el formulario se suba, verificara que haya seleccionado por lo menos una oficina, de no ser asi
        // mostrara una alerta
        let itemsContainer = document.getElementById("oficina-select-list-items")
        let itemsCount = itemsContainer.querySelectorAll(".item.checked").length
        console.log("count" + itemsCount)
        if (itemsCount <= 0) {
            evt.preventDefault()
            Swal.close()
            showFailAlert("Aviso", "Debe seleccionar por lo menos una oficina para registrar el puesto.")
            return;
        }

        // Aqui obtiene las opciones seleccionadas del filtro de 'Oficinas'
        let oficinaListItems = document.getElementById("oficina-select-list-items")
        oficinaListItems = oficinaListItems.querySelectorAll("li")
        oficinaListItems.forEach(item => {
            // Si el item esta seleccionado
            if (item.classList.contains("checked")) {
                // Obtiene el texto de el item
                let textContent = item.getElementsByClassName("item-text")[0].textContent
                // Crea un input hidden para enviarlo para la busqueda
                let inputHidden = document.createElement("input")
                inputHidden.type = "hidden"
                inputHidden.value = textContent
                inputHidden.name = "oficinas-items[]"
                // Agrega el input al formulario de busqueda
                searchForm.appendChild(inputHidden)

            }
        })
        */
    })



    // ----- Multiselect OFICINAS AL FILTRAR PUESTOS -------
    let oficinaFiltradoSelectBtn = document.getElementById("oficina-filtrado-select-btn")
    //const selectBtn = document.querySelector(".select-btn");
    //const oficinaItems = document.querySelectorAll(".item");
    let oficinaFiltradoItems = document.querySelectorAll(".oficina-filtrado-item")

    oficinaFiltradoSelectBtn.addEventListener("click", () => {
        oficinaFiltradoSelectBtn.classList.toggle("open")
    })

    oficinaFiltradoItems.forEach(item => {
        item.addEventListener("click", () => {
            item.classList.toggle("checked")

            //let checked = document.querySelectorAll(".checked"),
            //let checked = document.querySelectorAll('li[class="checked"][class="oficina-item"]')
            let checked = document.querySelectorAll(".checked.oficina-filtrado-item")
            btnText = document.querySelector(".oficina-filtrado-btn-text")



            if (checked && checked.length > 0) {
                btnText.innerText = `${checked.length} seleccionadas`
            } else {
                btnText.innerText = `Selecciona oficinas`
            }

            // Obtiene el texto de el primer elemento de la lista
            let itemText = item.getElementsByClassName("item-text")[0].textContent

            //alert("toogle -> " + itemText)

            // Si selecciona el item (Todas las oficinas) marcara todas las opciones
            if (itemText == DEFAULT_OFICINAS_ITEM && item.classList.contains("checked") && checked.length >= 1) {
                oficinaFiltradoItems.forEach(item => {
                    let itemText = item.getElementsByClassName("item-text")[0].textContent
                    //alert("todas ->>> " + itemText)
                    /*
                    let itemText = item.getElementsByClassName("item-text")[0].textContent
                    if (itemText != DEFAULT_OFICINAS_ITEM) {
                        item.classList.remove("checked")
                        btnText.innerText = DEFAULT_OFICINAS_ITEM
                    }
                    */
                    item.classList.add("checked")
                    btnText.innerText = DEFAULT_OFICINAS_ITEM
                })
            }

            // Si el usuario desmarca la opcion 'Todas las oficinas' desmarcara todas las opciones
            if (itemText == DEFAULT_OFICINAS_ITEM && !item.classList.contains("checked")) {
                oficinaFiltradoItems.forEach(item => {
                    let itemText = item.getElementsByClassName("item-text")[0].textContent
                    if (itemText != DEFAULT_OFICINAS_ITEM) {
                        item.classList.remove("checked")
                        btnText.innerText = DEFAULT_OFICINAS_ITEM
                    }
                })
                // Establece texto en boton
                btnText.innerText = `Selecciona oficinas`
            }

            // Si el usuario desmarca alguna otra opcion que no sea 'Todas las oficinas' desmarcara la opcion de 'Todas las oficinas'
            // (Si esta marcada)
            if (itemText != DEFAULT_OFICINAS_ITEM && !item.classList.contains("checked")) {
                //alert("des oficinas 2")

                let defaultOficinaItem = oficinaFiltradoItems[0] // 'Todas las oficinas'
                defaultOficinaItem.classList.remove("checked")

                // Despues de remover la opcion de 'Todas las oficinas',
                // Muestra el numero de opciones seleccionadas (Solo si hay almenos una)
                if (checked && checked.length > 0) {
                    checked = document.querySelectorAll(".checked.oficina-filtrado-item")
                    btnText.innerText = `${checked.length} seleccionadas`
                }

            }

            // Si selecciona la primera opción(Todas las oficinas) y solo hay una opcion
            // seleccionada, mostrara otro texto de el boton
            if (checked && checked.length == 1 && itemText == DEFAULT_OFICINAS_ITEM) {
                btnText.innerText = DEFAULT_OFICINAS_ITEM
            }
        })
    })

    // Formulario del filtrado de listado de puestos
    let filtrarPuestoForm = document.getElementById("filtrar-puesto-form")

    // Evento de onSubmit
    filtrarPuestoForm.addEventListener("submit", function (evt) {
        // Crea un input hidden que indica que el usuario quiere filtrar los puestos por oficina
        let input = document.createElement("input")
        input.type = "hidden"
        input.name = "filtrar-puestos"
        input.value = "true"
        filtrarPuestoForm.appendChild(input)

        // Aqui obtiene las oficinas seleccionadas para filtrar puestos
        let oficinaListItems = document.getElementById("oficina-filtrado-select-list-items")
        oficinaListItems = oficinaListItems.querySelectorAll("li")
        oficinaListItems.forEach(item => {
            // Si el item esta seleccionado
            if (item.classList.contains("checked")) {
                // Obtiene el texto de el item
                let textContent = item.getElementsByClassName("item-text")[0].textContent
                // Crea un input hidden para enviarlo para la busqueda
                let inputHidden = document.createElement("input")
                inputHidden.type = "hidden"
                inputHidden.value = textContent
                inputHidden.name = "oficinas-filtrado-items[]"
                // Agrega el input al formulario de busqueda
                filtrarPuestoForm.appendChild(inputHidden)

            }
        })
    })

})

// Funcion que recupera las oficinas seleccionadas al registrar el puesto
function recuperarOficinas(oficinasResponse) {
    //console.log(searchResponse)
    // Obtiene la respuesta de recuperacion de filtros y lo convierte a un objeto JavaScript
    let oficinasResponseO = JSON.parse(oficinasResponse)

    // Lista de opciones de oficinas seleccionadas
    let oficinasListQuery = oficinasResponseO["oficinas_list"]

    $(document).ready(function () {
        // ---- Recupera los filtros seleccionados de oficina ----

        try {
            // Obtiene todos los items <li> de el filtro de oficina
            let oficinaItems = document.querySelectorAll(".oficina-item")
            // Boton de multiselect
            let btnText = document.querySelector(".oficina-btn-text")
            // Itera sobre cada item visual y verifica si conincide con alguna opcion seleccionada de los filtros de busqueda
            // de ser asi, marcara el item visual como seleccionado (Simulando un click)
            oficinaItems.forEach(item => {
                let text = item.getElementsByClassName("item-text")[0].textContent
                //alert(text)
                for (var x = 0; x < oficinasListQuery.length; x++) {
                    if (text == oficinasListQuery[x]) {
                        // Marca la opcion como seleccionada
                        //item.click()
                        // Si se selecciono el item 'Todas las oficinas' marcara visualmente el item
                        // y cambiara el texto del boton de multiselect
                        if (oficinasListQuery.includes("Todas las oficinas")) {
                            item.classList.add("checked")
                            btnText.innerText = "Todas las oficinas"
                        } else {
                            item.click()
                        }
                    }
                }
            })
        }
        catch (excepcion) {
            console.error(excepcion)
        }

    })


}

// Funcion que recupera las oficinas seleccionadas al querer filtrar los puestos
function recuperarOficinasFiltrar(oficinasFiltradoResponse) {
    //console.log(searchResponse)
    // Obtiene la respuesta de recuperacion de filtros y lo convierte a un objeto JavaScript
    let oficinasResponseO = JSON.parse(oficinasFiltradoResponse)

    // Lista de opciones de oficinas seleccionadas
    let oficinasListQuery = oficinasResponseO["oficinas_filtrado_list"]

    console.log(oficinasListQuery)


    $(document).ready(function () {
        // ---- Recupera los filtros seleccionados de oficina ----

        try {
            // Obtiene todos los items <li> de el filtro de oficina
            let oficinaItems = document.querySelectorAll(".oficina-filtrado-item")
            // Boton de multiselect
            let btnText = document.querySelector(".oficina-filtrado-btn-text")
            // Itera sobre cada item visual y verifica si conincide con alguna opcion seleccionada de los filtros de busqueda
            // de ser asi, marcara el item visual como seleccionado (Simulando un click)
            oficinaItems.forEach(item => {
                let text = item.getElementsByClassName("item-text")[0].textContent
                //alert(text)
                for (var x = 0; x < oficinasListQuery.length; x++) {
                    console.log("index -> " + x + " text -> " + text + " == " + oficinasListQuery[x])
                    if (text == oficinasListQuery[x]) {
                        // Marca la opcion como seleccionada
                        //item.click()
                        // Si se selecciono el item 'Todas las oficinas' marcara visualmente el item
                        // y cambiara el texto del boton de multiselect
                        if (oficinasListQuery.includes("Todas las oficinas")) {
                            item.classList.add("checked")
                            btnText.innerText = "Todas las oficinas"
                        } else {
                            item.click()
                        }
                    }
                }
            })
        }
        catch (excepcion) {
            console.error(excepcion)
        }

    })

}

// Funcion que mostrara una alerta para que el usuario pueda cambiar el nombre de algun puesto
async function cambiarNombrePuesto(puestoId, nombreActual) {
    let inputValue = nombreActual
    // Muestra la alerta
    const { value: nuevoNombre } = await Swal.fire({
        title: "Ingrese un nuevo nombre",
        input: "text",
        inputLabel: "",
        inputValue,
        showCancelButton: true,
        cancelButtonText: "Cancelar",
        inputValidator: (value) => {
            if (!value) {
                return "¡Necesitas escribir algo!";
            }
        }
    });
    if (nuevoNombre) {
        showLoadingAlert("Modificando nombre...")

        var csrftoken = $("[name=csrfmiddlewaretoken]").val();

        $.ajax({
            type: "POST",
            url: `${CLIENTES}/listado-puestos-cliente`,
            headers: {
                "X-CSRFToken": csrftoken
            },
            data: {
                editar: true,
                nuevo_nombre: nuevoNombre,
                puesto_id: puestoId
            },
            success: function (data) {
                showSuccessConfirmAlert("Se modifico el nombre del puesto exitosamente", location.href)
            },
            error: function (a, b, c) {
                console.log(a, " ", b, " ", c)
            }
        })
    }
}


// Funcion que mostrara el listado de oficinas de un puesto de oficina
async function verOficinasPuesto(idPuesto) {
    let url = `${CLIENTES}/obtener-oficinas-puesto-cliente?`
    url += new URLSearchParams({
        id: idPuesto
    })

    let response = await fetch(url)

    if (!response.ok) {
        let error = await result.json()
        console.log(error)
        return;
    }

    let responseJson = await response.json()

    let oficinas = responseJson.oficinas

    var html = `
    <h2>Oficinas del puesto</h2>
        <br>
        <table class="table table-striped table-hover">
            <tr>
                <th>Nombre de oficina</th>
            <tr>
    `

    // Key -> Contendra el nombre de la oficina
    $.each(oficinas, function (i, oficina) {
        html += `
            <tr>
                <td>${oficina}</td>
            </tr>
        `
    })

    html += `
        </table>
    `
    Swal.fire({
        html: html
    });

}

// Funcion que exportara a excel el listado de puestos
async function exportarExcel(oficinasFiltradoRecoveryResponse) {
    showLoadingAlert("Exportando a Excel...")

    let url = `${CLIENTES}/listado-puestos-cliente?`
    let headers = new Headers()

    let oficinasFiltroPuestos = ""
    let oficinasFiltradoList = []

    if (oficinasFiltradoRecoveryResponse != null && oficinasFiltradoRecoveryResponse != "" && oficinasFiltradoRecoveryResponse != undefined) {
        oficinasFiltroPuestos = JSON.parse(oficinasFiltradoRecoveryResponse)
        oficinasFiltradoList = oficinasFiltroPuestos["oficinas_filtrado_list"] || []
    }

    let bodyParams = new URLSearchParams()
    bodyParams.append("exportar_excel", true)
    // Si selecciono oficinas para filtrar puestos, agregara las oficinas seleccionadas al cuerpo de la peticion
    bodyParams.append("filtrar-puestos", true)

    for (let oficina of oficinasFiltradoList) {
        bodyParams.append("oficinas-filtrado-items[]", oficina)
    }

    url += bodyParams.toString()

    const result = await fetch(url, {
        method: "GET",
        headers: headers
    })

    if (!result.ok) {
        let error = await result.json()
        console.log(error)
    }

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte puestos cliente.xlsx";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}

// Funcion que exportara a PDF el listado de puestos
async function exportarPdf(oficinasFiltradoRecoveryResponse) {
    showLoadingAlert("Exportando a PDF...")

    let url = `${CLIENTES}/listado-puestos-cliente?`
    let headers = new Headers()

    let oficinasFiltroPuestos = ""
    let oficinasFiltradoList = []

    if (oficinasFiltradoRecoveryResponse != null && oficinasFiltradoRecoveryResponse != "" && oficinasFiltradoRecoveryResponse != undefined) {
        oficinasFiltroPuestos = JSON.parse(oficinasFiltradoRecoveryResponse)
        oficinasFiltradoList = oficinasFiltroPuestos["oficinas_filtrado_list"] || []
    }

    let bodyParams = new URLSearchParams()
    bodyParams.append("exportar_pdf", true)
    // Si selecciono oficinas para filtrar puestos, agregara las oficinas seleccionadas al cuerpo de la peticion
    bodyParams.append("filtrar-puestos", true)
    for (let oficina of oficinasFiltradoList) {
        bodyParams.append("oficinas-filtrado-items[]", oficina)
    }

    url += bodyParams.toString()

    const result = await fetch(url, {
        method: "GET",
        headers: headers
    })

    if (!result.ok) {
        let error = await result.json()
        console.log(error)
    }

    const blob = await result.blob()

    objUrl = URL.createObjectURL(blob)

    const a = document.createElement('a');
    a.style.setProperty('display', 'none');
    document.body.appendChild(a);
    a.href = objUrl;
    a.download = "Reporte puestos cliente.pdf";
    a.click();
    window.URL.revokeObjectURL(objUrl);
    a.remove();

    Swal.close()
}
